/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.jncpv2.net;

import com.novell.java.lang.IntegerBuffer;
import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetAttributeInfo;
import com.novell.service.jncpv2.net.NetClassInfo;
import com.novell.service.jncpv2.net.NetMemory;
import com.novell.service.jncpv2.net.NetObjectInfo;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.jncpv2.net.NetSyntaxInfo;
import com.novell.service.session.SessionException;
import com.novell.service.toolkit.jcl.NWInteger;
import java.io.Serializable;

public class NetBuffer
implements Serializable {
    public static final int MAX_MESSAGE_LEN = 64512;
    public static final int DEFAULT_MESSAGE_LEN = 16384;
    public static final int MIN_MESSAGE_LEN = 2048;
    public static final int DSV_READ = 3;
    public static final int DSV_COMPARE = 4;
    public static final int DSV_LIST = 5;
    public static final int DSV_SEARCH = 6;
    public static final int DSV_ADD_ENTRY = 7;
    public static final int DSV_MODIFY_ENTRY = 9;
    public static final int DSV_READ_ATTR_DEF = 12;
    public static final int DSV_DEFINE_CLASS = 14;
    public static final int DSV_READ_CLASS_DEF = 15;
    public static final int DSV_MODIFY_CLASS_DEF = 16;
    public static final int DSV_LIST_CONTAINABLE_CLASSES = 18;
    public static final int DSV_ADD_PARTITION = 20;
    private NetService service;
    private int handle;

    public NetBuffer() {
        this.handle = 0;
    }

    public NetBuffer(NetService netService) throws NSIException {
        this(netService, 16384);
    }

    public NetBuffer(NetService netService, int n) throws NSIException {
        try {
            this.service = netService;
            this.handle = netService.allocBuf(n);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public NetBuffer(NetService netService, int n, int n2) throws NSIException {
        this(netService, n2);
        this.initBuf(n);
    }

    public final void initBuf(int n) throws NSIException {
        try {
            this.service.initBuf(n, this.handle);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final int getAttrCount() throws NSIException {
        try {
            return this.service.getAttrCount(this.handle);
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void getAttrName(StringBuffer stringBuffer, NWInteger nWInteger, NWInteger nWInteger2) throws NSIException {
        try {
            this.service.getAttrName(this.handle, stringBuffer, nWInteger, nWInteger2);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void computeAttrValSize(int n, NWInteger nWInteger) throws NSIException {
        try {
            this.service.computeAttrValSize(this.handle, n, nWInteger);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final int computeAttributeValueSize(int n) throws NSIException {
        try {
            NWInteger nWInteger = new NWInteger();
            this.service.computeAttrValSize(this.handle, n, nWInteger);
            return nWInteger.getValue();
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void getAttrVal(int n, NetMemory netMemory) throws NSIException {
        try {
            this.service.getAttrVal(this.handle, n, netMemory);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final byte[] getAttributeValue(int n) throws NSIException {
        try {
            return this.service.getAttributeValue(this.handle, n);
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void getClassDef(StringBuffer stringBuffer, NetClassInfo netClassInfo) throws NSIException {
        try {
            this.service.getClassDef(this.handle, stringBuffer, netClassInfo);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final int getClassDefCount() throws NSIException {
        try {
            IntegerBuffer integerBuffer = new IntegerBuffer();
            this.service.getClassDefCount(this.handle, integerBuffer);
            return integerBuffer.intValue();
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final String getClassItem() throws NSIException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.service.getClassItem(this.handle, stringBuffer);
            return stringBuffer.toString();
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final int getClassItemCount() throws NSIException {
        try {
            IntegerBuffer integerBuffer = new IntegerBuffer();
            this.service.getClassItemCount(this.handle, integerBuffer);
            return integerBuffer.intValue();
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final int getHandle() {
        return this.handle;
    }

    public final int getObjectCount() throws NSIException {
        try {
            NWInteger nWInteger = new NWInteger();
            this.service.getObjectCount(this.handle, nWInteger);
            return nWInteger.getValue();
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void getObjectName(StringBuffer stringBuffer, NWInteger nWInteger, NetObjectInfo netObjectInfo) throws NSIException {
        try {
            this.service.getObjectName(this.handle, stringBuffer, nWInteger, netObjectInfo);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void getAttrDef(StringBuffer stringBuffer, NetAttributeInfo netAttributeInfo) throws NSIException {
        try {
            this.service.getAttrDef(this.handle, stringBuffer, netAttributeInfo);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void getSyntaxDef(StringBuffer stringBuffer, NetSyntaxInfo netSyntaxInfo) throws NSIException {
        try {
            this.service.getSyntaxDef(this.handle, stringBuffer, netSyntaxInfo);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final int getSyntaxCount() throws NSIException {
        try {
            NWInteger nWInteger = new NWInteger();
            this.service.getSyntaxCount(this.handle, nWInteger);
            return nWInteger.getValue();
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void putChange(int n, String string) throws NSIException {
        try {
            this.service.putChange(this.handle, n, string);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void putClassItem(String string) throws NSIException {
        try {
            this.service.putClassItem(this.handle, string);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void putClassName(String string) throws NSIException {
        try {
            this.service.putClassName(this.handle, string);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void putAttributeName(String string) throws NSIException {
        try {
            this.service.putAttrName(this.handle, string);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void putSyntaxName(String string) throws NSIException {
        try {
            this.service.putSyntaxName(this.handle, string);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void putAttributeValue(int n, byte[] byArray) throws NSIException {
        try {
            this.service.putAttributeValue(this.handle, n, byArray);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void beginClassItem() throws NSIException {
        try {
            this.service.beginClassItem(this.handle);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final String getServerName(IntegerBuffer integerBuffer) throws NSIException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            this.service.getServerName(this.handle, stringBuffer, integerBuffer);
            return new String(stringBuffer);
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public final void getPartitionInfo(StringBuffer stringBuffer, IntegerBuffer integerBuffer) throws NSIException {
        try {
            this.service.getPartitionInfo(this.handle, stringBuffer, integerBuffer);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    protected void finalize() {
        try {
            this.service.freeBuf(this.handle);
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }
}

