/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.jncpv2.net;

import com.novell.java.io.EndianInputStream;
import com.novell.service.jncp.NSIException;
import com.novell.service.nds.NdsObjectInfo;
import java.io.IOException;
import java.io.Serializable;

public final class NetEntryInfo
implements NdsObjectInfo,
Serializable {
    private int outputFlags;
    private int entryId;
    private int entryFlags;
    private int subordinateCount;
    private int modificationTime;
    private int modificationTimestamp;
    private int creationTimestamp;
    private int partitionRootId;
    private int parentId;
    private int revisionCount;
    private int replicaType;
    private String baseClass;
    private String entryRDN;
    private String entryDN;
    private String partitionRootDN;
    private String parentDN;
    private int purgeTime;
    private String dereferenceBaseClass;
    private int replicaNumber;
    private int replicaState;
    private String federationBoundary;
    private String schemaBoundary;
    private boolean dereference;

    public NetEntryInfo(EndianInputStream endianInputStream) throws NSIException {
        this(endianInputStream, false);
    }

    public NetEntryInfo(EndianInputStream endianInputStream, boolean bl) throws NSIException {
        this.dereference = bl;
        try {
            endianInputStream.align32();
            this.outputFlags = endianInputStream.readLoHiInt();
            if ((this.outputFlags & 2) != 0) {
                this.entryId = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 4) != 0) {
                this.entryFlags = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 8) != 0) {
                this.subordinateCount = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x10) != 0) {
                this.modificationTime = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x20) != 0) {
                endianInputStream.readLoHiInt();
                endianInputStream.readLoHiShort();
                endianInputStream.readLoHiShort();
            }
            if ((this.outputFlags & 0x40) != 0) {
                endianInputStream.readLoHiInt();
                endianInputStream.readLoHiShort();
                endianInputStream.readLoHiShort();
            }
            if ((this.outputFlags & 0x80) != 0) {
                this.partitionRootId = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x100) != 0) {
                this.parentId = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x200) != 0) {
                this.revisionCount = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x400) != 0) {
                this.replicaType = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x800) != 0) {
                endianInputStream.readLoHiInt();
                this.baseClass = endianInputStream.readLoHiChars();
            }
            if ((this.outputFlags & 0x1000) != 0) {
                endianInputStream.align32();
                endianInputStream.readLoHiInt();
                this.entryRDN = endianInputStream.readLoHiChars();
            }
            if ((this.outputFlags & 0x2000) != 0) {
                endianInputStream.align32();
                endianInputStream.readLoHiInt();
                this.entryDN = endianInputStream.readLoHiChars();
            }
            if ((this.outputFlags & 0x4000) != 0) {
                endianInputStream.align32();
                endianInputStream.readLoHiInt();
                this.partitionRootDN = endianInputStream.readLoHiChars();
            }
            if ((this.outputFlags & 0x8000) != 0) {
                endianInputStream.align32();
                endianInputStream.readLoHiInt();
                this.parentDN = endianInputStream.readLoHiChars();
            }
            if ((this.outputFlags & 0x10000) != 0) {
                endianInputStream.align32();
                this.purgeTime = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x20000) != 0) {
                endianInputStream.align32();
                endianInputStream.readLoHiInt();
                this.dereferenceBaseClass = endianInputStream.readLoHiChars();
            }
            if ((this.outputFlags & 0x40000) != 0) {
                endianInputStream.align32();
                this.replicaNumber = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x80000) != 0) {
                this.replicaState = endianInputStream.readLoHiInt();
            }
            if ((this.outputFlags & 0x100000) != 0) {
                endianInputStream.align32();
                endianInputStream.readLoHiInt();
                this.federationBoundary = endianInputStream.readLoHiChars();
            }
            if ((this.outputFlags & 0x200000) != 0) {
                endianInputStream.align32();
                endianInputStream.readLoHiInt();
                this.schemaBoundary = endianInputStream.readLoHiChars();
                return;
            }
        }
        catch (IOException iOException) {
            throw new NSIException();
        }
    }

    public int getOutputFlags() {
        return this.outputFlags;
    }

    public int getEntryId() {
        return this.entryId;
    }

    public int getEntryFlags() {
        return this.entryFlags;
    }

    public int getSubordinateCount() {
        return this.subordinateCount;
    }

    public int getModificationTime() {
        return this.modificationTime;
    }

    public int getPartitionRootId() {
        return this.partitionRootId;
    }

    public int getParentId() {
        return this.parentId;
    }

    public int getRevisionCount() {
        return this.revisionCount;
    }

    public int getReplicaType() {
        return this.replicaType;
    }

    public String getBaseClass() {
        if (this.dereference) {
            return this.dereferenceBaseClass;
        }
        return this.baseClass;
    }

    public String getEntryRDN() {
        return this.entryRDN;
    }

    public String getEntryDN() {
        return this.entryDN;
    }

    public String getPartitionRootDN() {
        return this.partitionRootDN;
    }

    public String getParentDN() {
        return this.parentDN;
    }

    public int getPurgeTime() {
        return this.purgeTime;
    }

    public String getDereferenceBaseClass() {
        return this.dereferenceBaseClass;
    }

    public int getReplicaNumber() {
        return this.replicaNumber;
    }

    public int getReplicaState() {
        return this.replicaState;
    }

    public int getObjectFlags() {
        return this.entryFlags;
    }

    public String getFederationBoundary() {
        return this.federationBoundary;
    }

    public String getSchemaBoundary() {
        return this.schemaBoundary;
    }

    public boolean isManagementRoot() {
        return false;
    }
}

