/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.schema.SchemaNumber;
import java.io.Serializable;

public class NdsCounter
implements NdsAttributeValue,
SchemaNumber,
Cloneable,
Serializable {
    private static final int matchingRules = 5;
    protected int value;
    private String name;

    public NdsCounter(int n) {
        this("", n);
    }

    protected NdsCounter() {
        this.value = -1;
        this.name = null;
    }

    private NdsCounter(String string, long l) {
        this.value = (int)(l & 0xFFFFFFFFL);
        this.name = string;
    }

    protected NdsCounter(NdsCounter ndsCounter) {
        this.value = ndsCounter.value;
        this.name = ndsCounter.name;
    }

    public int compareTo(Object object) throws Exception {
        if (object instanceof NdsCounter) {
            int n = ((NdsCounter)object).intValue();
            if (this.value > n) {
                return 1;
            }
            if (this.value < n) {
                return -1;
            }
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsCounter) {
            return this.value == ((NdsCounter)object).intValue();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Counter";
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 22;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 5) == n;
    }

    public Object clone() {
        try {
            NdsCounter ndsCounter = (NdsCounter)super.clone();
            ndsCounter.value = this.value;
            ndsCounter.name = this.name;
            return ndsCounter;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public long getCounter() {
        return (long)this.value & 0xFFFFFFFFL;
    }
}

