/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.schema.SchemaNumber;
import java.io.Serializable;

public class NdsInteger
implements NdsAttributeValue,
SchemaNumber,
Cloneable,
Serializable {
    private static final int matchingRules = 5;
    protected int value;
    protected String name;

    public NdsInteger(long l) {
        this.value = (int)(l & 0xFFFFFFFFL);
    }

    protected NdsInteger() {
        this.value = -1;
    }

    protected NdsInteger(String string, long l) {
        this.name = string;
        this.value = (int)(l & 0xFFFFFFFFL);
    }

    protected NdsInteger(NdsInteger ndsInteger) {
        this.value = ndsInteger.value;
        this.name = ndsInteger.name;
    }

    public int compareTo(Object object) throws Exception {
        if (object instanceof NdsInteger) {
            int n = ((NdsInteger)object).intValue();
            if (this.value > n) {
                return 1;
            }
            if (this.value < n) {
                return -1;
            }
            return 0;
        }
        throw new IllegalArgumentException();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsInteger) {
            return this.value == ((NdsInteger)object).intValue();
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Integer";
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return (long)this.value & 0xFFFFFFFFL;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 8;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 5) == n;
    }

    public Object clone() {
        try {
            NdsInteger ndsInteger = (NdsInteger)super.clone();
            ndsInteger.value = this.value;
            ndsInteger.name = this.name;
            return ndsInteger;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        if (this.name == null) {
            return String.valueOf(this.getSyntaxId()) + " " + String.valueOf(this.value);
        }
        return String.valueOf(this.getSyntaxId()) + " " + this.name + " = " + String.valueOf(this.value);
    }

    public long getInteger() {
        return (long)this.value & 0xFFFFFFFFL;
    }
}

