/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.schema.SchemaSequence;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsOctetString
implements NdsAttributeValue,
SchemaSequence,
Cloneable,
Serializable {
    private static final int matchingRules = 5;
    protected byte[] value;
    private String name;

    public NdsOctetString(byte[] byArray) {
        this("", byArray);
    }

    protected NdsOctetString() {
    }

    private NdsOctetString(String string, byte[] byArray) {
        this.value = (byte[])byArray.clone();
        this.name = string;
    }

    protected NdsOctetString(NdsOctetString ndsOctetString) {
        this.value = ndsOctetString.value;
        this.name = ndsOctetString.name;
    }

    public int compareTo(Object object) throws Exception {
        if (object instanceof NdsOctetString) {
            ((NdsOctetString)object).getLength();
            byte[] byArray = ((NdsOctetString)object).getOctetString();
            int n = 0;
            while (n < this.value.length) {
                if (byArray[n] != this.value[n]) {
                    return this.value[n] - byArray[n];
                }
                ++n;
            }
            return 0;
        }
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object instanceof NdsOctetString && ((NdsOctetString)object).getLength() == this.value.length) {
            try {
                return this.compareTo(object) == 0;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Octet String";
    }

    public int count() {
        return this.value.length;
    }

    public Enumeration getValues() {
        Vector<Byte> vector = new Vector<Byte>();
        int n = 0;
        while (n < this.value.length) {
            vector.addElement(new Byte(this.value[n]));
            ++n;
        }
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 9;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 5) == n;
    }

    public Object clone() {
        try {
            NdsOctetString ndsOctetString = (NdsOctetString)super.clone();
            ndsOctetString.value = (byte[])this.value.clone();
            ndsOctetString.name = this.name;
            return ndsOctetString;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return new String(this.value);
    }

    public int getLength() {
        return this.value.length;
    }

    public byte[] getOctetString() {
        byte[] byArray = new byte[this.value.length];
        System.arraycopy(this.value, 0, byArray, 0, byArray.length);
        return byArray;
    }
}

