/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds;

import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsNetAddress;
import com.novell.service.nds.NdsString;
import com.novell.service.schema.SchemaComposite;
import com.novell.service.schema.SchemaValue;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class NdsReplicaPointer
implements NdsAttributeValue,
SchemaComposite,
Cloneable,
Serializable {
    private static final int matchingRules = 1;
    private static String[] compositeIds = new String[5];
    protected String serverName;
    protected int replicaType;
    protected int replicaNumber;
    protected NdsNetAddress[] replicaAddressHint;
    private String name;

    public NdsReplicaPointer(String string, int n, int n2, NdsNetAddress[] ndsNetAddressArray) {
        this("", string, n, n2, ndsNetAddressArray);
    }

    protected NdsReplicaPointer() {
        this.replicaType = -1;
        this.replicaNumber = -1;
    }

    private NdsReplicaPointer(String string, String string2, int n, int n2, NdsNetAddress[] ndsNetAddressArray) {
        this.serverName = string2;
        this.replicaType = n;
        this.replicaNumber = n2;
        this.replicaAddressHint = (NdsNetAddress[])ndsNetAddressArray.clone();
        this.name = string;
    }

    protected NdsReplicaPointer(NdsReplicaPointer ndsReplicaPointer) {
        this.serverName = ndsReplicaPointer.serverName;
        this.replicaType = ndsReplicaPointer.replicaType;
        this.replicaNumber = ndsReplicaPointer.replicaNumber;
        this.replicaAddressHint = ndsReplicaPointer.replicaAddressHint;
        this.name = ndsReplicaPointer.name;
    }

    public int compareTo(Object object) throws Exception {
        throw new Exception();
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof NdsReplicaPointer) {
            NdsReplicaPointer ndsReplicaPointer = (NdsReplicaPointer)object;
            if (!this.serverName.equals(ndsReplicaPointer.serverName)) {
                return false;
            }
            if (this.replicaType == ndsReplicaPointer.replicaType) {
                return false;
            }
            if (this.replicaNumber == ndsReplicaPointer.replicaNumber) {
                return false;
            }
            return this.replicaAddressHint.length != ndsReplicaPointer.replicaAddressHint.length;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getSyntaxId() {
        return "Replica Pointer";
    }

    public int count() {
        return compositeIds.length;
    }

    public SchemaValue getValue(String string) {
        if (string.equalsIgnoreCase(compositeIds[0])) {
            return new NdsString(compositeIds[0], this.serverName);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsInteger(compositeIds[1], this.replicaType);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsInteger(compositeIds[2], this.replicaNumber);
        }
        if (string.equalsIgnoreCase(compositeIds[1])) {
            return new NdsInteger(compositeIds[3], this.replicaAddressHint.length);
        }
        string.equalsIgnoreCase(compositeIds[1]);
        return null;
    }

    public Enumeration getValueIds() {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < compositeIds.length) {
            vector.addElement(compositeIds[n]);
            ++n;
        }
        return vector.elements();
    }

    public Enumeration getValues() {
        Vector<SchemaValue> vector = new Vector<SchemaValue>();
        vector.addElement(new NdsString(compositeIds[0], this.serverName));
        vector.addElement(new NdsInteger(compositeIds[1], this.replicaType));
        vector.addElement(new NdsInteger(compositeIds[2], this.replicaNumber));
        vector.addElement(new NdsInteger(compositeIds[3], this.replicaAddressHint.length));
        return vector.elements();
    }

    public boolean approximate(Object object) throws Exception {
        throw new Exception();
    }

    public int getNdsSyntaxId() {
        return 16;
    }

    public boolean supportsMatchingRules(int n) {
        return (n & 1) == n;
    }

    public Object clone() {
        try {
            NdsReplicaPointer ndsReplicaPointer = (NdsReplicaPointer)super.clone();
            ndsReplicaPointer.serverName = this.serverName;
            ndsReplicaPointer.replicaType = this.replicaType;
            ndsReplicaPointer.replicaNumber = this.replicaNumber;
            ndsReplicaPointer.replicaAddressHint = (NdsNetAddress[])this.replicaAddressHint.clone();
            ndsReplicaPointer.name = this.name;
            return ndsReplicaPointer;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        return String.valueOf(this.serverName) + ";" + String.valueOf(this.replicaType) + ";" + String.valueOf(this.replicaNumber) + ";" + String.valueOf(this.replicaAddressHint.length) + ";";
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getReplicaType() {
        return this.replicaType;
    }

    public int getReplicaNumber() {
        return this.replicaNumber;
    }

    public int getCount() {
        return this.replicaAddressHint.length;
    }

    public NdsNetAddress[] getReplicaAddressHint() {
        return (NdsNetAddress[])this.replicaAddressHint.clone();
    }

    static {
        NdsReplicaPointer.compositeIds[0] = "serverName";
        NdsReplicaPointer.compositeIds[1] = "replicaType";
        NdsReplicaPointer.compositeIds[2] = "replicaNumber";
        NdsReplicaPointer.compositeIds[3] = "count";
        NdsReplicaPointer.compositeIds[4] = "replicaAddressHint";
    }
}

