/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming;

import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.spi.ObjectFactory;

public class TransportContextFactoryBuilder
implements ContextFactoryBuilder {
    private static String defaultFactory = "com.novell.service.nds.naming.net.NetContextFactory";
    private static Properties protocolFactories = new Properties();

    public ObjectFactory createObjectFactory(Object object, Hashtable hashtable) {
        try {
            return this.createContextFactory(object, new NdsEnvironment(hashtable));
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public ContextFactory createContextFactory(Object object, Environment environment) throws NamingException {
        NdsEnvironment ndsEnvironment = this.getEnvironmentInstance(environment);
        String string = ndsEnvironment.getNdsTransportProtocol();
        try {
            Class<?> clazz = Class.forName(this.getClassName(string));
            return (ContextFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (InstantiationException instantiationException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
    }

    public String getClassName(String string) {
        string = string.toLowerCase();
        return protocolFactories.getProperty(string, defaultFactory);
    }

    private NdsEnvironment getEnvironmentInstance(Environment environment) throws NamingException {
        if (environment instanceof NdsEnvironment) {
            return (NdsEnvironment)environment;
        }
        return new NdsEnvironment(environment);
    }

    static {
        ((Hashtable)protocolFactories).put("ncp", "com.novell.service.nds.naming.net.NetContextFactory");
        ((Hashtable)protocolFactories).put("ldap", "com.novell.service.nds.naming.ldap.LdapContextFactory");
    }
}

