/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.local;

import com.novell.service.jncp.NSIException;
import com.novell.service.nds.naming.NdsDataAccessor;
import com.novell.service.nds.naming.NdsEnvironment;
import com.novell.service.nds.naming.NdsName;
import com.novell.service.nds.naming.NetSyntax;
import com.novell.service.nds.naming.TransportContextFactoryBuilder;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.Syntax;
import com.novell.utility.naming.URLParser;
import com.novell.utility.naming.spi.ContextFactory;
import com.novell.utility.naming.spi.ContextFactoryBuilder;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public final class NdsContextFactory
implements ContextFactory {
    private static ContextFactoryBuilder builder = new TransportContextFactoryBuilder();
    private static String defaultClass = "com.novell.service.nds.naming.local.NdsDirContext";
    private static Properties wrapperClasses = new Properties();

    public NdsContextFactory() {
    }

    public NdsContextFactory(NdsEnvironment ndsEnvironment) {
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        try {
            NdsEnvironment ndsEnvironment = new NdsEnvironment(hashtable);
            if (object instanceof Reference) {
                StringRefAddr stringRefAddr = (StringRefAddr)((Reference)object).get(0);
                URLParser uRLParser = new URLParser((String)stringRefAddr.getContent());
                ndsEnvironment.addToEnvironment("java.naming.provider.url", uRLParser.getURL());
                return this.getContextInstance(this.getCanonicalName(uRLParser.getPath()), ndsEnvironment);
            }
            if (object instanceof String) {
                return this.getContextInstance((String)object, ndsEnvironment);
            }
            if (object instanceof CompoundName) {
                return this.getContextInstance(object.toString(), ndsEnvironment);
            }
            return null;
        }
        catch (NamingException namingException) {
            return null;
        }
    }

    public Context getContextInstance(String string, Environment environment) throws NamingException {
        NdsEnvironment ndsEnvironment = this.getEnvironmentInstance(environment);
        ContextFactory contextFactory = builder.createContextFactory(string, ndsEnvironment);
        Context context = contextFactory.getContextInstance(string, ndsEnvironment);
        return this.getContextInstance(context);
    }

    public Context getContextInstance(String string, Object object, Environment environment) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public Context getContextInstance(Object object) throws NamingException {
        if (!(object instanceof NdsDataAccessor)) {
            throw new NamingException();
        }
        NdsDataAccessor ndsDataAccessor = (NdsDataAccessor)object;
        try {
            Class[] classArray = new Class[2];
            Object[] objectArray = new Object[2];
            Class<?> clazz = Class.forName(this.getClassName(ndsDataAccessor));
            classArray[0] = Class.forName("com.novell.service.nds.naming.NdsDirContextWrappable");
            classArray[1] = Class.forName("com.novell.service.nds.naming.NdsEnvironment");
            Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
            objectArray[0] = ndsDataAccessor;
            objectArray[1] = ndsDataAccessor.getEnvironmentInstance();
            return (Context)constructor.newInstance(objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(classNotFoundException);
            throw namingException;
        }
        catch (SecurityException securityException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(securityException);
            throw namingException;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(noSuchMethodException);
            throw namingException;
        }
        catch (InstantiationException instantiationException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(instantiationException);
            throw namingException;
        }
        catch (IllegalAccessException illegalAccessException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalAccessException);
            throw namingException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(illegalArgumentException);
            throw namingException;
        }
        catch (InvocationTargetException invocationTargetException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(invocationTargetException);
            throw namingException;
        }
    }

    public String getClassName(Object object) throws NamingException {
        try {
            String string;
            if (object instanceof NdsDataAccessor) {
                string = ((NdsDataAccessor)object).getBaseClass();
            } else if (object instanceof String) {
                string = (String)object;
            } else {
                throw new NamingException();
            }
            return wrapperClasses.getProperty(string, defaultClass);
        }
        catch (NSIException nSIException) {
            throw new NamingException();
        }
    }

    private NdsEnvironment getEnvironmentInstance(Environment environment) throws NamingException {
        if (environment instanceof NdsEnvironment) {
            return (NdsEnvironment)environment;
        }
        return new NdsEnvironment(environment);
    }

    private String getCanonicalName(String string) throws NamingException {
        NdsName ndsName = new NdsName(string == null ? "" : string, (Syntax)new NetSyntax());
        return ndsName.getCanonicalString();
    }

    static {
        ((Hashtable)wrapperClasses).put("AFP Server", "com.novell.service.nds.naming.local.AFPServerDirContext");
        ((Hashtable)wrapperClasses).put("Alias", "com.novell.service.nds.naming.local.AliasDirContext");
        ((Hashtable)wrapperClasses).put("Bindery Object", "com.novell.service.nds.naming.local.BinderyObjectDirContext");
        ((Hashtable)wrapperClasses).put("Bindery Queue", "com.novell.service.nds.naming.local.BinderyQueueDirContext");
        ((Hashtable)wrapperClasses).put("Computer", "com.novell.service.nds.naming.local.ComputerDirContext");
        ((Hashtable)wrapperClasses).put("Country", "com.novell.service.nds.naming.local.CountryDirContext");
        ((Hashtable)wrapperClasses).put("Directory Map", "com.novell.service.nds.naming.local.DirectoryMapDirContext");
        ((Hashtable)wrapperClasses).put("Group", "com.novell.service.nds.naming.local.GroupDirContext");
        ((Hashtable)wrapperClasses).put("List", "com.novell.service.nds.naming.local.ListDirContext");
        ((Hashtable)wrapperClasses).put("Locality", "com.novell.service.nds.naming.local.LocalityDirContext");
        ((Hashtable)wrapperClasses).put("Message Routing Group", "com.novell.service.nds.naming.local.MessageRoutingGroupDirContext");
        ((Hashtable)wrapperClasses).put("Messaging Server", "com.novell.service.nds.naming.local.MessagingServerDirContext");
        ((Hashtable)wrapperClasses).put("NCP Server", "com.novell.service.nds.naming.local.NCPServerDirContext");
        ((Hashtable)wrapperClasses).put("Organization", "com.novell.service.nds.naming.local.OrganizationDirContext");
        ((Hashtable)wrapperClasses).put("Organizational Role", "com.novell.service.nds.naming.local.OrganizationalRoleDirContext");
        ((Hashtable)wrapperClasses).put("Organizational Unit", "com.novell.service.nds.naming.local.OrganizationalUnitDirContext");
        ((Hashtable)wrapperClasses).put("Print Server", "com.novell.service.nds.naming.local.PrintServerDirContext");
        ((Hashtable)wrapperClasses).put("Printer", "com.novell.service.nds.naming.local.PrinterDirContext");
        ((Hashtable)wrapperClasses).put("Profile", "com.novell.service.nds.naming.local.ProfileDirContext");
        ((Hashtable)wrapperClasses).put("Queue", "com.novell.service.nds.naming.local.QueueDirContext");
        ((Hashtable)wrapperClasses).put("Top", "com.novell.service.nds.naming.local.TopDirContext");
        ((Hashtable)wrapperClasses).put("Unknown", "com.novell.service.nds.naming.local.UnknownDirContext");
        ((Hashtable)wrapperClasses).put("User", "com.novell.service.nds.naming.local.UserDirContext");
        ((Hashtable)wrapperClasses).put("Volume", "com.novell.service.nds.naming.local.VolumeDirContext");
    }
}

