/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetIterator;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsClassName;
import com.novell.service.nds.NdsDistinguishedName;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsIterator;
import com.novell.service.nds.NdsIteratorControls;
import com.novell.service.nds.NdsIteratorInfo;
import com.novell.service.nds.NdsIteratorResult;
import com.novell.service.nds.ldap.LdapAttributeValueFactory;
import com.novell.service.nds.naming.NdsNameParser;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetContextFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetFilter;
import com.novell.service.nds.naming.net.SearchObject;
import com.novell.service.nds.net.NetAttributeValue;
import com.novell.service.nds.net.NetAttributeValueFactory;
import com.novell.utility.naming.spi.ContextFactory;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;

public class BasicNdsIterator
implements NdsIterator,
Cloneable {
    private static ContextFactory factory = new NetContextFactory();
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private static NameParser nameParser = new NdsNameParser();
    protected NetIterator iterator;
    private NetEnvironment environment;
    private NetService service;
    private transient Object[] filterArgs;
    private transient NetFilter filter;
    private transient DirContext schemaContext;
    private boolean retObj = false;
    private boolean empty;
    private transient StreamTokenizer rfc;

    public BasicNdsIterator(String string, NetEnvironment netEnvironment, Attributes attributes, String[] stringArray) throws NSIException {
        this.environment = (NetEnvironment)netEnvironment.clone();
        try {
            int n;
            NetBuffer netBuffer;
            boolean bl;
            this.service = netEnvironment.getService();
            NetBuffer netBuffer2 = new NetBuffer(this.service, 28, netEnvironment.getBatchSize());
            this.filter = new NetFilter(this.service);
            if (stringArray == null) {
                bl = true;
                netBuffer = null;
            } else if (stringArray.length == 0) {
                bl = false;
                netBuffer = null;
            } else {
                bl = false;
                netBuffer = new NetBuffer(this.service, 6, netEnvironment.getBatchSize());
                n = 0;
                while (n < stringArray.length) {
                    netBuffer.putAttributeName(stringArray[n]);
                    ++n;
                }
            }
            if (attributes != null && attributes.size() > 0) {
                n = 1;
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration.hasMoreElements()) {
                    Attribute attribute = namingEnumeration.next();
                    if (attribute.size() > 0) {
                        boolean bl2 = true;
                        if (n == 0) {
                            this.filter.addFilterToken(2);
                        }
                        NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                        while (namingEnumeration2.hasMoreElements()) {
                            NdsAttributeValue ndsAttributeValue = (NdsAttributeValue)namingEnumeration2.nextElement();
                            NetAttributeValue netAttributeValue = ndsAttributeValue instanceof NetAttributeValue ? (NetAttributeValue)ndsAttributeValue : NetAttributeValueFactory.createValue(ndsAttributeValue);
                            if (!bl2) {
                                this.filter.addFilterToken(2);
                            }
                            this.filter.addFilterToken(14, attribute.getID(), netAttributeValue.getNdsSyntaxId());
                            this.filter.addFilterToken(7);
                            this.filter.addFilterToken(6, netAttributeValue.toByte(), netAttributeValue.getNdsSyntaxId());
                            bl2 = false;
                        }
                        n = 0;
                        continue;
                    }
                    throw new InvalidAttributeValueException();
                }
            } else {
                this.filter.addFilterToken(17);
                this.filter.addFilterToken(14, "*", 20);
            }
            this.filter.addFilterToken(0);
            this.filter.putFilter(netBuffer2);
            this.iterator = new NetIterator(this.service, string, netBuffer2.getHandle(), bl, netBuffer != null ? netBuffer.getHandle() : 0);
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
        this.empty = this.iterator.atEOF();
    }

    public BasicNdsIterator(String string, DirContext dirContext, NetEnvironment netEnvironment, String string2, Object[] objectArray, NdsIteratorControls ndsIteratorControls) throws NSIException {
        this.environment = (NetEnvironment)netEnvironment.clone();
        this.schemaContext = dirContext;
        if (ndsIteratorControls == null) {
            ndsIteratorControls = new NdsIteratorControls();
        }
        try {
            int n;
            NetBuffer netBuffer;
            boolean bl;
            this.service = netEnvironment.getService();
            this.filterArgs = objectArray;
            boolean bl2 = ndsIteratorControls.getDerefLinkFlag();
            String[] stringArray = ndsIteratorControls.getReturningAttributes();
            String string3 = this.getSortIndexString(ndsIteratorControls.getIndexSelect());
            String string4 = this.getSortIndexString(ndsIteratorControls.getSortKey());
            int n2 = ndsIteratorControls.getScalability();
            if (stringArray == null) {
                bl = true;
                netBuffer = null;
            } else if (stringArray.length == 0) {
                bl = false;
                netBuffer = null;
            } else {
                bl = false;
                netBuffer = new NetBuffer(this.service, 6, netEnvironment.getBatchSize());
                n = 0;
                while (n < stringArray.length) {
                    netBuffer.putAttributeName(stringArray[n]);
                    ++n;
                }
            }
            n = ndsIteratorControls.getSearchScope();
            n = n == 0 ? 0 : (n == 1 ? 1 : (n == 2 ? 2 : n));
            this.retObj = ndsIteratorControls.getReturningObjFlag();
            int n3 = ndsIteratorControls.getTimeLimit();
            this.rfc = new StreamTokenizer(new StringReader(string2));
            this.rfc.resetSyntax();
            this.rfc.whitespaceChars(0, 32);
            this.rfc.wordChars(64, 122);
            this.rfc.wordChars(48, 57);
            this.rfc.wordChars(58, 58);
            this.rfc.wordChars(45, 45);
            this.rfc.wordChars(95, 95);
            this.rfc.wordChars(32, 32);
            this.rfc.wordChars(46, 46);
            NetBuffer netBuffer2 = new NetBuffer(this.service, 28, netEnvironment.getBatchSize());
            this.filter = new NetFilter(this.service);
            this.parseFilter();
            this.filter.addFilterToken(0);
            this.filter.putFilter(netBuffer2);
            this.iterator = new NetIterator(this.service, string, n, bl2, netBuffer2.getHandle(), 0, 1, bl, netBuffer != null ? netBuffer.getHandle() : 0, string3, string4, n2, n3);
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
        this.empty = this.iterator.atEOF();
    }

    public NdsIteratorInfo getInfo() throws NSIException {
        return this.iterator.getInfo();
    }

    public int getPosition(int n) throws NSIException {
        return this.iterator.getPosition(n);
    }

    public void setPosition(int n, int n2) throws NSIException {
        this.iterator.setPosition(n, n2);
    }

    public void setPosition(NdsIterator ndsIterator, int n) throws NSIException {
        this.iterator.setPosition(((BasicNdsIterator)ndsIterator).iterator, n);
    }

    public void setPosition(String string, String string2, int n) throws NSIException {
        if (string.equalsIgnoreCase("Name")) {
            this.iterator.setPosition("_RDN", string2, n);
            return;
        }
        this.iterator.setPosition(string, string2, n);
    }

    public int skip(int n, int n2) throws NSIException {
        return this.iterator.skip(n, n2);
    }

    public boolean hasNext() throws NSIException {
        return !this.iterator.atEOF();
    }

    public NamingEnumeration next(int n, int n2) throws NSIException {
        return new NextEnumerator(n, n2);
    }

    public boolean hasPrevious() throws NSIException {
        return !this.iterator.atFirst() && !this.empty;
    }

    public NamingEnumeration previous(int n, int n2) throws NSIException {
        return new PreviousEnumerator(n, n2);
    }

    public Object current() throws NSIException {
        try {
            return new CurrentEnumerator().next();
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }

    public int count(int n, int n2, boolean bl) throws NSIException {
        return this.iterator.count(n, n2, bl);
    }

    public void close() throws NSIException {
        this.iterator.destroy();
    }

    public Object clone() {
        try {
            BasicNdsIterator basicNdsIterator = (BasicNdsIterator)super.clone();
            basicNdsIterator.iterator = (NetIterator)this.iterator.clone();
            basicNdsIterator.environment = (NetEnvironment)this.environment.clone();
            basicNdsIterator.service = basicNdsIterator.environment.getService();
            basicNdsIterator.retObj = this.retObj;
            return basicNdsIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }

    private void parseFilter() throws InvalidSearchFilterException, NamingException {
        try {
            if (this.rfc.nextToken() != 40) {
                throw new InvalidSearchFilterException();
            }
        }
        catch (IOException iOException) {
            throw new NamingException();
        }
        this.parseFilterComp();
    }

    private void parseFilterComp() throws InvalidSearchFilterException, NamingException {
        try {
            Object object;
            int n = this.rfc.nextToken();
            String string = null;
            int n2 = -1;
            if (n == -3) {
                string = this.rfc.sval.trim();
                if (string.equalsIgnoreCase("name")) {
                    n2 = 1;
                } else if (string.equalsIgnoreCase("baseclass")) {
                    n2 = 20;
                } else {
                    Attributes attributes = this.schemaContext.getAttributes(String.valueOf(string) + ".SC=Attributes");
                    object = attributes.get("Syntax ID");
                    NamingEnumeration<?> namingEnumeration = object.getAll();
                    NdsInteger ndsInteger = (NdsInteger)namingEnumeration.nextElement();
                    n2 = ndsInteger.intValue();
                }
            }
            if (n == 38) {
                this.parseFilterList(2);
                return;
            }
            if (n == 124) {
                this.parseFilterList(1);
                return;
            }
            if (n == 33) {
                this.filter.addFilterToken(3);
                this.parseFilter();
                if (this.rfc.nextToken() != 41) {
                    throw new InvalidSearchFilterException();
                }
            } else {
                int n3 = this.rfc.nextToken();
                object = null;
                if (n3 == 62) {
                    if (this.rfc.nextToken() != 61) {
                        throw new InvalidSearchFilterException();
                    }
                    n3 = 8;
                    object = this.parseRfc1778Value(n2);
                } else if (n3 == 60) {
                    if (this.rfc.nextToken() != 61) {
                        throw new InvalidSearchFilterException();
                    }
                    n3 = 9;
                    object = this.parseRfc1778Value(n2);
                } else if (n3 == 126) {
                    if (this.rfc.nextToken() != 61) {
                        throw new InvalidSearchFilterException();
                    }
                    n3 = 10;
                    object = this.parseRfc1778Value(n2);
                } else if (n3 == 61) {
                    this.rfc.wordChars(42, 42);
                    int n4 = this.rfc.nextToken();
                    if (n4 == -3 && this.rfc.sval.equals("*")) {
                        n3 = 15;
                        if (this.rfc.nextToken() != 41) {
                            throw new InvalidSearchFilterException();
                        }
                    } else {
                        this.rfc.pushBack();
                        n3 = 7;
                        object = this.parseRfc1778Value(n2);
                    }
                    this.rfc.ordinaryChar(42);
                } else {
                    throw new InvalidSearchFilterException();
                }
                if (string.equalsIgnoreCase("name")) {
                    this.filter.addFilterToken(16);
                    if (n3 == 15) {
                        this.filter.addFilterToken(14, "*", n2);
                        return;
                    }
                    this.filter.addFilterToken(14, ((NdsDistinguishedName)object).getDistinguishedName(), n2);
                    return;
                }
                if (string.equalsIgnoreCase("baseclass")) {
                    this.filter.addFilterToken(17);
                    if (n3 == 15) {
                        this.filter.addFilterToken(14, "*", n2);
                        return;
                    }
                    this.filter.addFilterToken(14, ((NdsClassName)object).getClassName(), n2);
                    return;
                }
                if (n3 == 15) {
                    this.filter.addFilterToken(15);
                    this.filter.addFilterToken(14, string, n2);
                    return;
                }
                this.filter.addFilterToken(14, string, n2);
                this.filter.addFilterToken(n3);
                this.filter.addFilterToken(6, object.toByte(), n2);
            }
            return;
        }
        catch (IOException iOException) {
            throw new NamingException();
        }
        catch (Exception exception) {
            try {
                this.filter.addFilterToken(3);
                this.filter.addFilterToken(15);
                this.filter.addFilterToken(14, "Object Class", 20);
                return;
            }
            catch (Exception exception2) {
                throw new NamingException();
            }
        }
    }

    private void parseFilterList(int n) throws InvalidSearchFilterException, NamingException {
        boolean bl = false;
        try {
            this.filter.addFilterToken(4);
            while (this.rfc.nextToken() == 40) {
                if (bl) {
                    this.filter.addFilterToken(n);
                }
                this.parseFilterComp();
                bl = true;
            }
            this.filter.addFilterToken(5);
            return;
        }
        catch (Exception exception) {
            throw new NamingException();
        }
    }

    private NetAttributeValue parseRfc1778Value(int n) throws InvalidSearchFilterException, NamingException {
        NdsAttributeValue ndsAttributeValue = null;
        NetAttributeValue netAttributeValue = null;
        StringBuffer stringBuffer = new StringBuffer();
        try {
            this.rfc.nextToken();
            if (this.rfc.ttype == 123) {
                this.rfc.nextToken();
                try {
                    int n2 = Integer.parseInt(this.rfc.sval);
                    ndsAttributeValue = (NdsAttributeValue)this.filterArgs[n2];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                    invalidSearchFilterException.setRootCause(arrayIndexOutOfBoundsException);
                    throw invalidSearchFilterException;
                }
                catch (NumberFormatException numberFormatException) {
                    InvalidSearchFilterException invalidSearchFilterException = new InvalidSearchFilterException();
                    invalidSearchFilterException.setRootCause(numberFormatException);
                    throw invalidSearchFilterException;
                }
                if (this.rfc.nextToken() != 125) {
                    throw new InvalidSearchFilterException();
                }
            } else {
                stringBuffer.append(this.rfc.sval);
                while (this.rfc.nextToken() != 41) {
                    switch (this.rfc.ttype) {
                        case -3: {
                            stringBuffer.append(this.rfc.sval);
                            break;
                        }
                        case -2: {
                            stringBuffer.append(this.rfc.nval);
                            break;
                        }
                        case -1: {
                            throw new InvalidSearchFilterException();
                        }
                        default: {
                            stringBuffer.append(this.rfc.ttype);
                        }
                    }
                }
                ndsAttributeValue = LdapAttributeValueFactory.createValue(n, stringBuffer.toString());
            }
            netAttributeValue = ndsAttributeValue instanceof NetAttributeValue ? (NetAttributeValue)ndsAttributeValue : NetAttributeValueFactory.createValue(ndsAttributeValue);
        }
        catch (Exception exception) {
            throw new NamingException();
        }
        return netAttributeValue;
    }

    public String getSortIndexString(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            do {
                String string;
                if ((string = stringArray[n++]).equalsIgnoreCase("Name")) {
                    stringBuffer.append("_RDN");
                    continue;
                }
                if (string.equalsIgnoreCase("BaseClass")) {
                    stringBuffer.append("_BaseClass");
                    continue;
                }
                stringBuffer.append(string);
            } while (n < stringArray.length && stringBuffer.append(',') != null);
            return new String(stringBuffer);
        }
        return "";
    }

    class NextEnumerator
    implements NamingEnumeration {
        private int entries;
        private int timeout;
        private NetIterationHandle iteration;
        private NetBuffer objectInfo;
        private int objectCount;
        private SearchObject nextSearchObject;

        public NextEnumerator(int n, int n2) {
            BasicNdsIterator.this = BasicNdsIterator.this;
            this.entries = n;
            this.timeout = n2;
            this.iteration = new NetIterationHandle(BasicNdsIterator.this.service, 110);
            this.objectInfo = new NetBuffer(BasicNdsIterator.this.service, BasicNdsIterator.this.environment.getBatchSize());
            this.nextSearchObject = this.getFirstSearchObject();
        }

        public boolean hasMoreElements() {
            return this.hasMore();
        }

        public boolean hasMore() {
            return this.nextSearchObject != null;
        }

        private int updateObjectInfo() throws NSIException {
            BasicNdsIterator.this.iterator.getNext(this.entries, this.timeout, this.iteration, this.objectInfo);
            return this.objectInfo.getObjectCount();
        }

        private SearchObject getFirstSearchObject() throws NSIException {
            try {
                this.objectCount = this.updateObjectInfo();
                if (this.objectCount == 0) {
                    return null;
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, BasicNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        private SearchObject getNextSearchObject() throws NSIException {
            try {
                while (this.objectCount == 0) {
                    if (!this.iteration.moreIterations()) {
                        return null;
                    }
                    this.objectCount = this.updateObjectInfo();
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, BasicNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }

        public Object next() throws NamingException {
            if (!this.hasMore()) {
                throw new NoSuchElementException();
            }
            try {
                Cloneable cloneable;
                Context context = null;
                SearchObject searchObject = this.nextSearchObject;
                this.nextSearchObject = this.getNextSearchObject();
                while (searchObject.equalsApproximate(this.nextSearchObject)) {
                    cloneable = this.nextSearchObject.getAttributes();
                    searchObject.mergeAttributes((Attributes)cloneable);
                    this.nextSearchObject = this.getNextSearchObject();
                }
                if (BasicNdsIterator.this.retObj) {
                    context = factory.getContextInstance(searchObject.getName(), searchObject.getNdsObjectInfo(), BasicNdsIterator.this.environment);
                }
                cloneable = nameParser.parse(searchObject.getName());
                return new NdsIteratorResult(cloneable.get(cloneable.size() - 1), context, searchObject.getAttributes(), searchObject.getNdsObjectInfo(), true);
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }

        public void close() throws NamingException {
            try {
                this.iteration.closeIteration();
                return;
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }
    }

    class PreviousEnumerator
    implements NamingEnumeration {
        private int entries;
        private int timeout;
        private NetIterationHandle iteration;
        private NetBuffer objectInfo;
        private int objectCount;
        private SearchObject nextSearchObject;

        public PreviousEnumerator(int n, int n2) {
            BasicNdsIterator.this = BasicNdsIterator.this;
            this.entries = n;
            this.timeout = n2;
            this.iteration = new NetIterationHandle(BasicNdsIterator.this.service, 110);
            this.objectInfo = new NetBuffer(BasicNdsIterator.this.service, BasicNdsIterator.this.environment.getBatchSize());
            this.nextSearchObject = this.getFirstSearchObject();
        }

        public boolean hasMoreElements() {
            return this.hasMore();
        }

        public boolean hasMore() {
            return this.nextSearchObject != null;
        }

        private int updateObjectInfo() throws NSIException {
            BasicNdsIterator.this.iterator.getPrev(this.entries, this.timeout, this.iteration, this.objectInfo);
            return this.objectInfo.getObjectCount();
        }

        private SearchObject getFirstSearchObject() throws NSIException {
            try {
                this.objectCount = this.updateObjectInfo();
                if (this.objectCount == 0) {
                    return null;
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, BasicNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        private SearchObject getNextSearchObject() throws NSIException {
            try {
                while (this.objectCount == 0) {
                    if (!this.iteration.moreIterations()) {
                        return null;
                    }
                    this.objectCount = this.updateObjectInfo();
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, BasicNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }

        public Object next() throws NamingException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            try {
                Cloneable cloneable;
                SearchObject searchObject = this.nextSearchObject;
                this.nextSearchObject = this.getNextSearchObject();
                while (searchObject.equalsApproximate(this.nextSearchObject)) {
                    cloneable = this.nextSearchObject.getAttributes();
                    searchObject.mergeAttributes((Attributes)cloneable);
                    this.nextSearchObject = this.getNextSearchObject();
                }
                Context context = factory.getContextInstance(searchObject.getName(), searchObject.getNdsObjectInfo(), BasicNdsIterator.this.environment);
                cloneable = nameParser.parse(searchObject.getName());
                return new NdsIteratorResult(cloneable.get(cloneable.size() - 1), BasicNdsIterator.this.retObj ? context : null, searchObject.getAttributes(), searchObject.getNdsObjectInfo(), true);
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }

        public void close() throws NamingException {
            try {
                this.iteration.closeIteration();
                return;
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }
    }

    class CurrentEnumerator
    implements NamingEnumeration {
        private int entries = 1;
        private int timeout = 0;
        private NetIterationHandle iteration;
        private NetBuffer objectInfo;
        private int objectCount;
        private SearchObject nextSearchObject;

        public CurrentEnumerator() {
            BasicNdsIterator.this = BasicNdsIterator.this;
            this.iteration = new NetIterationHandle(BasicNdsIterator.this.service, 110);
            this.objectInfo = new NetBuffer(BasicNdsIterator.this.service, BasicNdsIterator.this.environment.getBatchSize());
            this.nextSearchObject = this.getFirstSearchObject();
        }

        public boolean hasMoreElements() {
            return this.hasMore();
        }

        public boolean hasMore() {
            return this.nextSearchObject != null;
        }

        private int updateObjectInfo() throws NSIException {
            BasicNdsIterator.this.iterator.getCurrent(this.iteration, this.objectInfo);
            return this.objectInfo.getObjectCount();
        }

        private SearchObject getFirstSearchObject() throws NSIException {
            try {
                this.objectCount = this.updateObjectInfo();
                if (this.objectCount == 0) {
                    return null;
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, BasicNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        private SearchObject getNextSearchObject() throws NSIException {
            try {
                while (this.objectCount == 0) {
                    if (!this.iteration.moreIterations()) {
                        return null;
                    }
                    this.objectCount = this.updateObjectInfo();
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, BasicNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }

        public Object next() throws NamingException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            try {
                Cloneable cloneable;
                SearchObject searchObject = this.nextSearchObject;
                this.nextSearchObject = this.getNextSearchObject();
                while (searchObject.equalsApproximate(this.nextSearchObject)) {
                    cloneable = this.nextSearchObject.getAttributes();
                    searchObject.mergeAttributes((Attributes)cloneable);
                    this.nextSearchObject = this.getNextSearchObject();
                }
                Context context = factory.getContextInstance(searchObject.getName(), searchObject.getNdsObjectInfo(), BasicNdsIterator.this.environment);
                cloneable = nameParser.parse(searchObject.getName());
                return new NdsIteratorResult(cloneable.get(cloneable.size() - 1), BasicNdsIterator.this.retObj ? context : null, searchObject.getAttributes(), searchObject.getNdsObjectInfo(), true);
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }

        public void close() throws NamingException {
            try {
                this.iteration.closeIteration();
                return;
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }
    }
}

