/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetIterator;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsIterator;
import com.novell.service.nds.NdsIteratorControls;
import com.novell.service.nds.NdsIteratorInfo;
import com.novell.service.nds.NdsIteratorResult;
import com.novell.service.nds.naming.NdsNameParser;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetContextFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.SearchObject;
import com.novell.utility.naming.spi.ContextFactory;
import java.util.NoSuchElementException;
import javax.naming.Context;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;

public class ListNdsIterator
implements NdsIterator,
Cloneable {
    private static ContextFactory factory = new NetContextFactory();
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private static NameParser nameParser = new NdsNameParser();
    protected NetIterator iterator;
    private NetEnvironment environment;
    private NetService service;
    private boolean retObj = false;
    private boolean empty;

    public ListNdsIterator(String string, NetEnvironment netEnvironment, String string2, String string3, NdsIteratorControls ndsIteratorControls) throws NSIException {
        this.environment = (NetEnvironment)netEnvironment.clone();
        this.retObj = ndsIteratorControls.getReturningObjFlag();
        try {
            this.service = netEnvironment.getService();
            this.iterator = new NetIterator(this.service, string, string2, string3, ndsIteratorControls.getScalability(), ndsIteratorControls.getTimeLimit());
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
        this.empty = this.iterator.atEOF();
    }

    public NdsIteratorInfo getInfo() throws NSIException {
        return this.iterator.getInfo();
    }

    public int getPosition(int n) throws NSIException {
        return this.iterator.getPosition(n);
    }

    public void setPosition(int n, int n2) throws NSIException {
        this.iterator.setPosition(n, n2);
    }

    public void setPosition(NdsIterator ndsIterator, int n) throws NSIException {
        this.iterator.setPosition(((ListNdsIterator)ndsIterator).iterator, n);
    }

    public void setPosition(String string, String string2, int n) throws NSIException {
        if (string.equalsIgnoreCase("Name")) {
            this.iterator.setPosition("_RDN", string2, n);
            return;
        }
        this.iterator.setPosition(string, string2, n);
    }

    public int skip(int n, int n2) throws NSIException {
        return this.iterator.skip(n, n2);
    }

    public boolean hasNext() throws NSIException {
        return !this.iterator.atEOF();
    }

    public NamingEnumeration next(int n, int n2) throws NSIException {
        return new NextEnumerator(n, n2);
    }

    public boolean hasPrevious() throws NSIException {
        return !this.iterator.atFirst() && !this.empty;
    }

    public NamingEnumeration previous(int n, int n2) throws NSIException {
        return new PreviousEnumerator(n, n2);
    }

    public Object current() throws NSIException {
        try {
            return new CurrentEnumerator().next();
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }

    public int count(int n, int n2, boolean bl) throws NSIException {
        return this.iterator.count(n, n2, bl);
    }

    public void close() throws NSIException {
        this.iterator.destroy();
    }

    public Object clone() {
        try {
            ListNdsIterator listNdsIterator = (ListNdsIterator)super.clone();
            listNdsIterator.iterator = (NetIterator)this.iterator.clone();
            listNdsIterator.environment = (NetEnvironment)this.environment.clone();
            listNdsIterator.service = listNdsIterator.environment.getService();
            listNdsIterator.retObj = this.retObj;
            return listNdsIterator;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        catch (NamingException namingException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(namingException);
            throw nSIException;
        }
    }

    class NextEnumerator
    implements NamingEnumeration {
        private int entries;
        private int timeout;
        private NetIterationHandle iteration;
        private NetBuffer objectInfo;
        private int objectCount;
        private SearchObject nextSearchObject;

        public NextEnumerator(int n, int n2) {
            ListNdsIterator.this = ListNdsIterator.this;
            this.entries = n;
            this.timeout = n2;
            this.iteration = new NetIterationHandle(ListNdsIterator.this.service, 110);
            this.objectInfo = new NetBuffer(ListNdsIterator.this.service, ListNdsIterator.this.environment.getBatchSize());
            this.nextSearchObject = this.getFirstSearchObject();
        }

        public boolean hasMoreElements() {
            return this.hasMore();
        }

        public boolean hasMore() {
            return this.nextSearchObject != null;
        }

        private int updateObjectInfo() throws NSIException {
            ListNdsIterator.this.iterator.getNext(this.entries, this.timeout, this.iteration, this.objectInfo);
            return this.objectInfo.getObjectCount();
        }

        private SearchObject getFirstSearchObject() throws NSIException {
            try {
                this.objectCount = this.updateObjectInfo();
                if (this.objectCount == 0) {
                    return null;
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, ListNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        private SearchObject getNextSearchObject() throws NSIException {
            try {
                while (this.objectCount == 0) {
                    if (!this.iteration.moreIterations()) {
                        return null;
                    }
                    this.objectCount = this.updateObjectInfo();
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, ListNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }

        public Object next() throws NamingException {
            if (!this.hasMore()) {
                throw new NoSuchElementException();
            }
            try {
                Cloneable cloneable;
                Context context = null;
                SearchObject searchObject = this.nextSearchObject;
                this.nextSearchObject = this.getNextSearchObject();
                while (searchObject.equalsApproximate(this.nextSearchObject)) {
                    cloneable = this.nextSearchObject.getAttributes();
                    searchObject.mergeAttributes((Attributes)cloneable);
                    this.nextSearchObject = this.getNextSearchObject();
                }
                if (ListNdsIterator.this.retObj) {
                    context = factory.getContextInstance(searchObject.getName(), searchObject.getNdsObjectInfo(), ListNdsIterator.this.environment);
                }
                cloneable = nameParser.parse(searchObject.getName());
                return new NdsIteratorResult(cloneable.get(cloneable.size() - 1), context, searchObject.getAttributes(), searchObject.getNdsObjectInfo(), true);
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }

        public void close() throws NamingException {
            try {
                this.iteration.closeIteration();
                return;
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }
    }

    class PreviousEnumerator
    implements NamingEnumeration {
        private int entries;
        private int timeout;
        private NetIterationHandle iteration;
        private NetBuffer objectInfo;
        private int objectCount;
        private SearchObject nextSearchObject;

        public PreviousEnumerator(int n, int n2) {
            ListNdsIterator.this = ListNdsIterator.this;
            this.entries = n;
            this.timeout = n2;
            this.iteration = new NetIterationHandle(ListNdsIterator.this.service, 110);
            this.objectInfo = new NetBuffer(ListNdsIterator.this.service, ListNdsIterator.this.environment.getBatchSize());
            this.nextSearchObject = this.getFirstSearchObject();
        }

        public boolean hasMoreElements() {
            return this.hasMore();
        }

        public boolean hasMore() {
            return this.nextSearchObject != null;
        }

        private int updateObjectInfo() throws NSIException {
            ListNdsIterator.this.iterator.getPrev(this.entries, this.timeout, this.iteration, this.objectInfo);
            return this.objectInfo.getObjectCount();
        }

        private SearchObject getFirstSearchObject() throws NSIException {
            try {
                this.objectCount = this.updateObjectInfo();
                if (this.objectCount == 0) {
                    return null;
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, ListNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        private SearchObject getNextSearchObject() throws NSIException {
            try {
                while (this.objectCount == 0) {
                    if (!this.iteration.moreIterations()) {
                        return null;
                    }
                    this.objectCount = this.updateObjectInfo();
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, ListNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }

        public Object next() throws NamingException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            try {
                Cloneable cloneable;
                SearchObject searchObject = this.nextSearchObject;
                this.nextSearchObject = this.getNextSearchObject();
                while (searchObject.equalsApproximate(this.nextSearchObject)) {
                    cloneable = this.nextSearchObject.getAttributes();
                    searchObject.mergeAttributes((Attributes)cloneable);
                    this.nextSearchObject = this.getNextSearchObject();
                }
                Context context = factory.getContextInstance(searchObject.getName(), searchObject.getNdsObjectInfo(), ListNdsIterator.this.environment);
                cloneable = nameParser.parse(searchObject.getName());
                return new NdsIteratorResult(cloneable.get(cloneable.size() - 1), ListNdsIterator.this.retObj ? context : null, searchObject.getAttributes(), searchObject.getNdsObjectInfo(), true);
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }

        public void close() throws NamingException {
            try {
                this.iteration.closeIteration();
                return;
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }
    }

    class CurrentEnumerator
    implements NamingEnumeration {
        private int entries = 1;
        private int timeout = 0;
        private NetIterationHandle iteration;
        private NetBuffer objectInfo;
        private int objectCount;
        private SearchObject nextSearchObject;

        public CurrentEnumerator() {
            ListNdsIterator.this = ListNdsIterator.this;
            this.iteration = new NetIterationHandle(ListNdsIterator.this.service, 110);
            this.objectInfo = new NetBuffer(ListNdsIterator.this.service, ListNdsIterator.this.environment.getBatchSize());
            this.nextSearchObject = this.getFirstSearchObject();
        }

        public boolean hasMoreElements() {
            return this.hasMore();
        }

        public boolean hasMore() {
            return this.nextSearchObject != null;
        }

        private int updateObjectInfo() throws NSIException {
            ListNdsIterator.this.iterator.getCurrent(this.iteration, this.objectInfo);
            return this.objectInfo.getObjectCount();
        }

        private SearchObject getFirstSearchObject() throws NSIException {
            try {
                this.objectCount = this.updateObjectInfo();
                if (this.objectCount == 0) {
                    return null;
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, ListNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        private SearchObject getNextSearchObject() throws NSIException {
            try {
                while (this.objectCount == 0) {
                    if (!this.iteration.moreIterations()) {
                        return null;
                    }
                    this.objectCount = this.updateObjectInfo();
                }
                --this.objectCount;
                return new SearchObject(this.objectInfo, ListNdsIterator.this.environment);
            }
            catch (NamingException namingException) {
                throw new NSIException();
            }
        }

        public Object nextElement() {
            try {
                return this.next();
            }
            catch (NamingException namingException) {
                throw new NoSuchElementException();
            }
        }

        public Object next() throws NamingException {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            try {
                Cloneable cloneable;
                SearchObject searchObject = this.nextSearchObject;
                this.nextSearchObject = this.getNextSearchObject();
                while (searchObject.equalsApproximate(this.nextSearchObject)) {
                    cloneable = this.nextSearchObject.getAttributes();
                    searchObject.mergeAttributes((Attributes)cloneable);
                    this.nextSearchObject = this.getNextSearchObject();
                }
                Context context = factory.getContextInstance(searchObject.getName(), searchObject.getNdsObjectInfo(), ListNdsIterator.this.environment);
                cloneable = nameParser.parse(searchObject.getName());
                return new NdsIteratorResult(cloneable.get(cloneable.size() - 1), ListNdsIterator.this.retObj ? context : null, searchObject.getAttributes(), searchObject.getNdsObjectInfo(), true);
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }

        public void close() throws NamingException {
            try {
                this.iteration.closeIteration();
                return;
            }
            catch (NSIException nSIException) {
                NamingException namingException = exceptionFactory.getNamingException(nSIException);
                throw namingException;
            }
        }
    }
}

