/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetAsn1ID;
import com.novell.service.jncpv2.net.NetAttributeInfo;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetReadAttrDefBuffer;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsOctetString;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.AttributeDefinitionsBindingEnumerator;
import com.novell.service.nds.naming.net.AttributeDefinitionsNameClassEnumerator;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetSchemaContainerDirContext;
import com.novell.service.nds.naming.net.NetSchemaDirContext;
import com.novell.service.session.SessionException;
import com.sun.jndi.toolkit.ctx.Continuation;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;

public class NetAttributeDefinitionsDirContext
extends NetSchemaContainerDirContext {
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    protected NetAttributeDefinitionsDirContext(String string, String string2, NetEnvironment netEnvironment) throws NamingException {
        super(string, string2, netEnvironment);
    }

    protected NamingEnumeration schema_list(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new AttributeDefinitionsNameClassEnumerator(this);
    }

    protected NamingEnumeration schema_listBindings(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new AttributeDefinitionsBindingEnumerator(this);
    }

    protected void schema_destroySubcontext(String string, Continuation continuation) throws NamingException {
        if (!this.exists(string)) {
            continuation.setError((Object)this, string);
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            throw continuation.fillInException(nameNotFoundException);
        }
        try {
            NetService netService = this.environment.getService();
            netService.removeAttrDef(string);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, string);
            throw continuation.fillInException(namingException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            continuation.setError((Object)this, string);
            namingException.setRootCause(sessionException);
            throw continuation.fillInException(namingException);
        }
        continuation.setSuccess();
    }

    protected DirContext schema_createSubcontext(String string, Attributes attributes, Continuation continuation) throws NamingException {
        if (this.isEmpty(string)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new InvalidNameException());
        }
        String string2 = NetSchemaDirContext.nameParser.parse(string).get(0);
        if (this.exists(string2)) {
            continuation.setError((Object)this, string);
            throw continuation.fillInException(new NameAlreadyBoundException());
        }
        if (attributes == null) {
            attributes = new BasicAttributes();
        }
        try {
            long l = 0L;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 0L;
            NetAsn1ID netAsn1ID = new NetAsn1ID();
            Attribute attribute = attributes.get("Flags");
            Attribute attribute2 = attributes.get("Syntax ID");
            Attribute attribute3 = attributes.get("Lower Limit");
            Attribute attribute4 = attributes.get("Upper Limit");
            Attribute attribute5 = attributes.get("ASN1Name");
            if (attribute != null) {
                l = ((NdsInteger)attribute.getAll().nextElement()).getInteger();
            }
            if (attribute2 != null) {
                l2 = ((NdsInteger)attribute2.getAll().nextElement()).getInteger();
            }
            if (attribute3 != null) {
                l3 = ((NdsInteger)attribute3.getAll().nextElement()).getInteger();
            }
            if (attribute4 != null) {
                l4 = ((NdsInteger)attribute4.getAll().nextElement()).getInteger();
            }
            if (attribute5 != null) {
                netAsn1ID.setData(((NdsOctetString)attribute5.getAll().nextElement()).getOctetString());
            }
            NetAttributeInfo netAttributeInfo = new NetAttributeInfo((int)l, (int)l2, (int)l3, (int)l4, netAsn1ID);
            NetService netService = this.environment.getService();
            netService.defineAttr(string2, netAttributeInfo);
            return (DirContext)this.a_lookup(string, continuation);
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            continuation.setError((Object)this, string);
            throw continuation.fillInException(namingException);
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            continuation.setError((Object)this, string);
            namingException.setRootCause(sessionException);
            throw continuation.fillInException(namingException);
        }
    }

    protected boolean exists(String string) {
        try {
            NetIterationHandle netIterationHandle = new NetIterationHandle(this.getService(), 12);
            NetBuffer netBuffer = new NetBuffer(this.getService(), 12, this.environment.getBatchSize());
            NetReadAttrDefBuffer netReadAttrDefBuffer = new NetReadAttrDefBuffer(this.getService(), 0, this.environment.getBatchSize());
            netBuffer.putAttributeName(string);
            NetService netService = this.environment.getService();
            netService.readAttrDef(0, false, netBuffer.getHandle(), netIterationHandle, netReadAttrDefBuffer);
            return true;
        }
        catch (NamingException namingException) {
        }
        catch (NSIException nSIException) {
        }
        catch (SessionException sessionException) {}
        return false;
    }
}

