/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetClassInfo;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetReadClassDefBuffer;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsClassName;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.SchemaContextFactory;
import com.novell.service.session.SessionException;
import com.novell.utility.naming.spi.ContextFactory;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class NetClassDefinitionsBindingEnumerator
implements NamingEnumeration {
    private static final String CLASSES_BINDING_NAME = "SC=Classes";
    private static ContextFactory factory = new SchemaContextFactory();
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private NetEnvironment environment;
    private int classAttributesLevel;
    private NetService service;
    private NetIterationHandle iterationHandle;
    private NetBuffer classNames;
    private NetReadClassDefBuffer classDefs;
    private Enumeration entries;

    public NetClassDefinitionsBindingEnumerator(NamingEnumeration namingEnumeration, NetEnvironment netEnvironment) throws NamingException {
        try {
            this.environment = netEnvironment;
            this.service = netEnvironment.getService();
            this.iterationHandle = new NetIterationHandle(this.service, 15);
            this.classNames = new NetBuffer(this.service, 15, netEnvironment.getBatchSize());
            while (namingEnumeration.hasMore()) {
                this.classNames.putClassName(((NdsClassName)namingEnumeration.next()).getClassName());
            }
            this.classDefs = new NetReadClassDefBuffer(this.service, 1, netEnvironment.getBatchSize());
            this.getClassDefs();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public boolean hasMoreElements() {
        return this.entries.hasMoreElements() || this.iterationHandle.moreIterations();
    }

    public boolean hasMore() throws NamingException {
        return this.hasMoreElements();
    }

    private void getClassDefs() throws NSIException {
        try {
            this.service.readClassDef(1, false, this.classNames.getHandle(), this.iterationHandle, this.classDefs);
            this.entries = this.classDefs.getEntries();
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    public Object nextElement() {
        try {
            return this.next();
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException();
        }
    }

    public Object next() throws NamingException {
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        try {
            if (!this.entries.hasMoreElements()) {
                this.getClassDefs();
            }
            NetClassInfo netClassInfo = (NetClassInfo)this.entries.nextElement();
            StringBuffer stringBuffer = new StringBuffer(256);
            stringBuffer.append("\"");
            stringBuffer.append(netClassInfo.getName());
            stringBuffer.append("\".");
            stringBuffer.append(CLASSES_BINDING_NAME);
            return new Binding(netClassInfo.getName(), factory.getContextInstance(new String(stringBuffer), netClassInfo, this.environment));
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public void close() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

