/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetEntryInfo;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsAttributeValue;
import com.novell.service.nds.NdsCaseIgnoreString;
import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsTime;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetEntryAttributeId;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.SessionException;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;

public class NetEntryAttributes
extends BasicAttributes {
    private static String[] allAttributeNames = new String[]{"Entry Id", "Entry Flags", "Subordinate Count", "Modification Time", "Partition Root Id", "Parent Id", "Revision Count", "Replica Type", "Base Class", "Entry RDN", "Entry DN", "Partition Root DN", "Parent DN", "Purge Time", "Dereference Base Class", "Federation Boundary", "Schema Boundary"};
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private String objectName;
    private NetEnvironment environment;
    private NetService service;
    private NetEntryInfo entryInfo;

    public NetEntryAttributes(String string, String[] stringArray, NetEnvironment netEnvironment) throws NamingException {
        this.objectName = string;
        this.environment = netEnvironment;
        this.service = netEnvironment.getService();
        if (stringArray == null) {
            stringArray = allAttributeNames;
        }
        try {
            this.getEntryInfo();
        }
        catch (NSIException nSIException) {
            throw exceptionFactory.getNamingException(nSIException);
        }
        int n = 0;
        while (n < stringArray.length) {
            Integer n2 = NetEntryAttributeId.getEntryInfoFlag(stringArray[n]);
            if (n2 != null) {
                NdsAttributeValue ndsAttributeValue = this.createValue(n2);
                super.put(new BasicAttribute(stringArray[n], ndsAttributeValue));
            }
            ++n;
        }
    }

    private void getEntryInfo() throws NSIException {
        try {
            this.entryInfo = this.service.readEntry(this.objectName, this.environment.getBatchSize());
            return;
        }
        catch (SessionException sessionException) {
            NSIException nSIException = new NSIException();
            nSIException.setRootCause(sessionException);
            throw nSIException;
        }
    }

    private NdsAttributeValue createValue(int n) throws NSIException {
        switch (n) {
            case 2: {
                return new NdsInteger(this.entryInfo.getEntryId());
            }
            case 4: {
                return new NdsInteger(this.entryInfo.getEntryFlags());
            }
            case 8: {
                return new NdsInteger(this.entryInfo.getSubordinateCount());
            }
            case 128: {
                return new NdsInteger(this.entryInfo.getPartitionRootId());
            }
            case 256: {
                return new NdsInteger(this.entryInfo.getParentId());
            }
            case 512: {
                return new NdsInteger(this.entryInfo.getRevisionCount());
            }
            case 1024: {
                return new NdsInteger(this.entryInfo.getReplicaType());
            }
            case 16: {
                return new NdsTime(this.entryInfo.getModificationTime());
            }
            case 65536: {
                return new NdsTime(this.entryInfo.getPurgeTime());
            }
            case 2048: {
                return new NdsCaseIgnoreString(this.entryInfo.getBaseClass());
            }
            case 4096: {
                return new NdsCaseIgnoreString(this.entryInfo.getEntryRDN());
            }
            case 8192: {
                return new NdsCaseIgnoreString(this.entryInfo.getEntryDN());
            }
            case 16384: {
                return new NdsCaseIgnoreString(this.entryInfo.getPartitionRootDN());
            }
            case 32768: {
                return new NdsCaseIgnoreString(this.entryInfo.getParentDN());
            }
            case 131072: {
                return new NdsCaseIgnoreString(this.entryInfo.getDereferenceBaseClass());
            }
            case 32: 
            case 64: 
            case 0x100000: {
                return new NdsCaseIgnoreString(this.entryInfo.getFederationBoundary());
            }
            case 0x200000: {
                return new NdsCaseIgnoreString(this.entryInfo.getSchemaBoundary());
            }
        }
        throw new NSIException();
    }
}

