/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetPartitionDirContext;
import com.novell.service.nds.naming.net.NetPartitionEnumerator;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class NetPartitionBindingEnumerator
implements NamingEnumeration {
    private NetPartitionEnumerator partEnum;
    private NetEnvironment netEnv;
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();

    public NetPartitionBindingEnumerator(NetEnvironment netEnvironment, String string) throws NamingException {
        try {
            this.partEnum = new NetPartitionEnumerator(netEnvironment.getService(), string);
            this.netEnv = netEnvironment;
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public boolean hasMoreElements() {
        return this.partEnum.hasMoreElements();
    }

    public Object nextElement() throws NoSuchElementException {
        String string = (String)this.partEnum.nextElement();
        NetPartitionDirContext netPartitionDirContext = null;
        try {
            netPartitionDirContext = new NetPartitionDirContext(string, this.netEnv);
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException(namingException.getMessage());
        }
        return new Binding(string, netPartitionDirContext);
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object next() throws NamingException {
        return this.nextElement();
    }

    public void close() throws NamingException {
        this.partEnum.closeIteration();
    }
}

