/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.nds.NdsInteger;
import com.novell.service.nds.NdsNetAddress;
import com.novell.service.nds.NdsReplicaPointer;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.naming.net.NetReplicaServerInfo;
import com.novell.service.nds.naming.net.NetReplicaSyncInfo;
import com.novell.service.nds.naming.net.PartitionFunctions;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.InvalidAttributeIdentifierException;

public class NetReplicaAttribute
extends BasicAttribute {
    public NetReplicaAttribute(String string, String string2, NetEnvironment netEnvironment, String string3, NdsReplicaPointer ndsReplicaPointer, NetReplicaSyncInfo netReplicaSyncInfo, NetReplicaServerInfo netReplicaServerInfo) throws NamingException {
        super(string3);
        new PartitionFunctions(netEnvironment);
        if (string3.equalsIgnoreCase("Name")) {
            this.add(string);
            return;
        }
        if (string3.equalsIgnoreCase("Type")) {
            int n = ndsReplicaPointer.getReplicaType() & 0xFFFF;
            this.add(new NdsInteger(n));
            return;
        }
        if (string3.equalsIgnoreCase("State")) {
            int n = ndsReplicaPointer.getReplicaType() & 0xFFFF0000;
            this.add(new NdsInteger(n >>= 16));
            return;
        }
        if (string3.equalsIgnoreCase("Number")) {
            this.add(new NdsInteger(ndsReplicaPointer.getReplicaNumber()));
            return;
        }
        if (string3.equalsIgnoreCase("Replica Address Hints")) {
            NdsNetAddress[] ndsNetAddressArray = ndsReplicaPointer.getReplicaAddressHint();
            int n = 0;
            while (n < ndsNetAddressArray.length) {
                this.add(ndsNetAddressArray[n]);
                ++n;
            }
            return;
        }
        if (string3.equalsIgnoreCase("Server Read")) {
            this.add(netReplicaServerInfo.getServerRead());
            return;
        }
        if (string3.equalsIgnoreCase("Partition Name")) {
            this.add(string2);
            return;
        }
        if (string3.equalsIgnoreCase("Last Successful Sync Time")) {
            this.add(new NdsInteger(netReplicaSyncInfo.getLastSyncTime()));
            return;
        }
        if (string3.equalsIgnoreCase("Sync Error")) {
            this.add(new NdsInteger(netReplicaSyncInfo.getErrorCode()));
            return;
        }
        if (string3.equalsIgnoreCase("Replica Server Name")) {
            this.add(netReplicaServerInfo.getServerName());
            return;
        }
        if (string3.equalsIgnoreCase("Replica Server Addresses")) {
            Vector vector = netReplicaServerInfo.getNetAddresses();
            int n = 0;
            while (n < vector.size()) {
                this.add(vector.elementAt(n));
                ++n;
            }
            return;
        }
        if (string3.equalsIgnoreCase("Replica Server Sync Time Unit")) {
            this.add(new NdsInteger(netReplicaServerInfo.getTimeInSync()));
            return;
        }
        if (string3.equalsIgnoreCase("Modification Timestamp")) {
            this.add(netReplicaServerInfo.getModificationTime());
            return;
        }
        if (string3.equalsIgnoreCase("Busy")) {
            this.add(netReplicaServerInfo.getBusyState());
            return;
        }
        throw new InvalidAttributeIdentifierException(string3);
    }
}

