/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.NdsReplicaPointer;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetAttributeValueEnumerator;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.nds.net.NetAttributeValueFactory;
import java.util.NoSuchElementException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class NetReplicaNameClassEnumerator
implements NamingEnumeration {
    private String partitionName;
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    NetService service;
    NetAttributeValueEnumerator rawValues;

    public NetReplicaNameClassEnumerator(NetEnvironment netEnvironment, String string) throws NamingException {
        this.partitionName = string;
        this.service = netEnvironment.getService();
        try {
            this.rawValues = new NetAttributeValueEnumerator(this.service, string, "Replica");
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }

    public boolean hasMoreElements() {
        return this.rawValues.hasMoreElements();
    }

    public Object nextElement() throws NoSuchElementException {
        try {
            NdsReplicaPointer ndsReplicaPointer = null;
            ndsReplicaPointer = (NdsReplicaPointer)NetAttributeValueFactory.createValue(16, (byte[])this.rawValues.nextElement(), null, null, this.partitionName, "Replica");
            return new NameClassPair(ndsReplicaPointer.getServerName(), "NdsReplicaDirContext");
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException(nSIException.getMessage());
        }
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object next() throws NamingException {
        return this.nextElement();
    }

    public void close() throws NamingException {
        this.rawValues.closeIteration();
    }
}

