/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetAttrInfo;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetClassInfo;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetReadAttrDefBuffer;
import com.novell.service.jncpv2.net.NetReadClassDefBuffer;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.nds.naming.NdsNameParser;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetAttributeDefinitionDirContext;
import com.novell.service.nds.naming.net.NetClassDefinitionDirContext;
import com.novell.service.nds.naming.net.NetEnvironment;
import com.novell.service.session.SessionException;
import com.novell.utility.naming.Environment;
import com.novell.utility.naming.spi.ContextFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public final class SchemaContextFactory
implements ContextFactory {
    private static NameParser parser = new NdsNameParser();
    private static String defaultContext;
    private static Properties netContexts;
    private static NdsNamingExceptionFactory exceptionFactory;

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        NetEnvironment netEnvironment = new NetEnvironment(hashtable);
        if (object instanceof String) {
            return this.getContextInstance((String)object, netEnvironment);
        }
        if (object instanceof CompoundName) {
            return this.getContextInstance(object.toString(), netEnvironment);
        }
        throw new Exception();
    }

    public Context getContextInstance(String string, Environment environment) throws NamingException {
        NetEnvironment netEnvironment = this.getEnvironmentInstance(environment);
        Object object = this.getSchemaInfo(string, netEnvironment);
        return this.getContextInstance(string, object, netEnvironment);
    }

    public Context getContextInstance(String string, Object object, Environment environment) throws NamingException {
        NetEnvironment netEnvironment = this.getEnvironmentInstance(environment);
        if (object instanceof NetAttrInfo) {
            return new NetAttributeDefinitionDirContext(string, (NetAttrInfo)object, netEnvironment);
        }
        if (object instanceof NetClassInfo) {
            return new NetClassDefinitionDirContext(string, (NetClassInfo)object, netEnvironment);
        }
        if (object instanceof String) {
            try {
                Class[] classArray = new Class[3];
                Object[] objectArray = new Object[3];
                Class<?> clazz = Class.forName(this.getClassName((String)object));
                classArray[0] = Class.forName("java.lang.String");
                classArray[1] = Class.forName("java.lang.String");
                classArray[2] = Class.forName("com.novell.service.nds.naming.net.NetEnvironment");
                Constructor<?> constructor = clazz.getDeclaredConstructor(classArray);
                objectArray[0] = string;
                objectArray[1] = object;
                objectArray[2] = netEnvironment;
                return (Context)constructor.newInstance(objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(classNotFoundException);
                throw namingException;
            }
            catch (SecurityException securityException) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(securityException);
                throw namingException;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(noSuchMethodException);
                throw namingException;
            }
            catch (InstantiationException instantiationException) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(instantiationException);
                throw namingException;
            }
            catch (IllegalAccessException illegalAccessException) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(illegalAccessException);
                throw namingException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(illegalArgumentException);
                throw namingException;
            }
            catch (InvocationTargetException invocationTargetException) {
                NamingException namingException = new NamingException();
                namingException.setRootCause(invocationTargetException);
                throw namingException;
            }
        }
        throw new NamingException();
    }

    public Context getContextInstance(Object object) throws NamingException {
        throw new OperationNotSupportedException();
    }

    public String getClassName(Object object) {
        return netContexts.getProperty((String)object, defaultContext);
    }

    private Object getSchemaInfo(String string, NetEnvironment netEnvironment) throws NamingException {
        NetService netService = netEnvironment.getService();
        Name name = parser.parse(string.toLowerCase());
        switch (name.size()) {
            case 1: {
                String string2 = name.get(0);
                int n = string2.indexOf("schema");
                if (n == -1 || n > 3) break;
                return "Schema Container";
            }
            case 2: {
                String string3 = name.get(1);
                int n = string3.indexOf("classes");
                if (n != -1) {
                    if (n > 3) break;
                    return "Class Container";
                }
                n = string3.indexOf("attributes");
                if (n != -1) {
                    if (n > 3) break;
                    return "Attribute Container";
                }
                n = string3.indexOf("syntaxes");
                if (n == -1) break;
                if (n <= 3) {
                    return "Syntax Container";
                }
                return "Schema Syntax";
            }
            case 3: {
                String string4 = name.get(1);
                int n = string4.indexOf("classes");
                if (n != -1) {
                    if (n > 3) break;
                    return this.getClassInfo(string, netService, netEnvironment);
                }
                n = string4.indexOf("attributes");
                if (n != -1) {
                    if (n > 3) break;
                    return this.getAttrInfo(string, netService, netEnvironment);
                }
                n = string4.indexOf("syntaxes");
                if (n == -1 || n > 3) break;
                if (this.schemaSyntaxExists(string, netService)) {
                    return "Schema Syntax";
                }
                throw new NameNotFoundException();
            }
        }
        throw new NameNotFoundException();
    }

    protected Object getClassInfo(String string, NetService netService, NetEnvironment netEnvironment) throws NamingException {
        try {
            Name name = new NdsNameParser().parse(string);
            String string2 = name.get(name.size() - 1);
            NetIterationHandle netIterationHandle = new NetIterationHandle(netService, 15);
            NetBuffer netBuffer = new NetBuffer(netService, 15, 4096);
            NetReadClassDefBuffer netReadClassDefBuffer = new NetReadClassDefBuffer(netService, netEnvironment.getClassAttributesLevel(), netEnvironment.getBatchSize());
            netBuffer.putClassName(string2);
            netService.readClassDef(netEnvironment.getClassAttributesLevel(), false, netBuffer.getHandle(), netIterationHandle, netReadClassDefBuffer);
            return netReadClassDefBuffer.getEntries().nextElement();
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
    }

    protected Object getAttrInfo(String string, NetService netService, NetEnvironment netEnvironment) throws NamingException {
        try {
            Name name = parser.parse(string);
            String string2 = name.get(name.size() - 1);
            NetIterationHandle netIterationHandle = new NetIterationHandle(netService, 12);
            NetBuffer netBuffer = new NetBuffer(netService, 12, 4096);
            NetReadAttrDefBuffer netReadAttrDefBuffer = new NetReadAttrDefBuffer(netService, 1, netEnvironment.getBatchSize());
            netBuffer.putAttributeName(string2);
            netService.readAttrDef(1, false, netBuffer.getHandle(), netIterationHandle, netReadAttrDefBuffer);
            return netReadAttrDefBuffer.getEntries().nextElement();
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
    }

    protected boolean schemaSyntaxExists(String string, NetService netService) throws NamingException {
        try {
            Name name = parser.parse(string);
            string = name.get(name.size() - 1);
            NetIterationHandle netIterationHandle = new NetIterationHandle(netService, 40);
            NetBuffer netBuffer = new NetBuffer(netService, 40, 4096);
            NetBuffer netBuffer2 = new NetBuffer(netService);
            int n = string.indexOf(61);
            if (n != -1) {
                string = string.substring(n + 1);
            }
            netBuffer.putSyntaxName(string);
            netService.readSyntaxes(0, false, netBuffer.getHandle(), netIterationHandle, netBuffer2.getHandle());
            return true;
        }
        catch (NSIException nSIException) {
        }
        catch (SessionException sessionException) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(sessionException);
            throw namingException;
        }
        return false;
    }

    private NetEnvironment getEnvironmentInstance(Environment environment) throws NamingException {
        if (environment instanceof NetEnvironment) {
            return (NetEnvironment)environment;
        }
        return new NetEnvironment(environment);
    }

    static {
        netContexts = new Properties();
        exceptionFactory = new NdsNamingExceptionFactory();
        ((Hashtable)netContexts).put("Schema Container", "com.novell.service.nds.naming.net.NetSchemaRootDirContext");
        ((Hashtable)netContexts).put("Attribute Container", "com.novell.service.nds.naming.net.NetAttributeDefinitionsDirContext");
        ((Hashtable)netContexts).put("Class Container", "com.novell.service.nds.naming.net.NetClassDefinitionsDirContext");
        ((Hashtable)netContexts).put("Syntax Container", "com.novell.service.nds.naming.net.NetSyntaxDefinitionsDirContext");
        ((Hashtable)netContexts).put("Schema Attribute", "com.novell.service.nds.naming.net.NetAttributeDefinitionDirContext");
        ((Hashtable)netContexts).put("Schema Class", "com.novell.service.nds.naming.net.NetClassDefinitionDirContext");
        ((Hashtable)netContexts).put("Schema Syntax", "com.novell.service.nds.naming.net.NetSyntaxDefinitionDirContext");
    }
}

