/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nds.naming.net;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncpv2.net.NetBuffer;
import com.novell.service.jncpv2.net.NetIterationHandle;
import com.novell.service.jncpv2.net.NetService;
import com.novell.service.jncpv2.net.NetSyntaxInfo;
import com.novell.service.nds.naming.NdsNamingExceptionFactory;
import com.novell.service.nds.naming.net.NetSyntaxDefinitionsDirContext;
import com.novell.service.nds.naming.net.SchemaContextFactory;
import com.novell.utility.naming.spi.ContextFactory;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

class SyntaxDefinitionsBindingEnumerator
implements NamingEnumeration {
    private static ContextFactory factory = new SchemaContextFactory();
    private static NdsNamingExceptionFactory exceptionFactory = new NdsNamingExceptionFactory();
    private NetService service;
    private NetIterationHandle iterationHandle;
    private NetBuffer syntaxDefs;
    private int entriesLeft;
    private NetSyntaxDefinitionsDirContext syntaxDefsContext;

    public SyntaxDefinitionsBindingEnumerator(NetSyntaxDefinitionsDirContext netSyntaxDefinitionsDirContext) throws NamingException {
        try {
            this.service = netSyntaxDefinitionsDirContext.getService();
            this.syntaxDefsContext = netSyntaxDefinitionsDirContext;
            this.iterationHandle = new NetIterationHandle(this.service, 40);
            this.syntaxDefs = new NetBuffer(this.service, netSyntaxDefinitionsDirContext.environment.getBatchSize());
            this.getSyntaxDefs();
            return;
        }
        catch (Exception exception) {
            NamingException namingException = new NamingException();
            namingException.setRootCause(exception);
            throw namingException;
        }
    }

    public boolean hasMoreElements() {
        return this.entriesLeft != 0 || this.iterationHandle.moreIterations();
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public Object nextElement() {
        Context context;
        if (!this.hasMoreElements()) {
            throw new NoSuchElementException();
        }
        if (this.entriesLeft == 0) {
            this.getSyntaxDefs();
        }
        StringBuffer stringBuffer = new StringBuffer();
        NetSyntaxInfo netSyntaxInfo = new NetSyntaxInfo();
        try {
            this.syntaxDefs.getSyntaxDef(stringBuffer, netSyntaxInfo);
            --this.entriesLeft;
        }
        catch (NSIException nSIException) {
            throw new NoSuchElementException();
        }
        try {
            context = factory.getContextInstance(new String("\"" + stringBuffer + "\"." + this.syntaxDefsContext.getDistinguishedName()), this.syntaxDefsContext.environment);
        }
        catch (NamingException namingException) {
            throw new NoSuchElementException(namingException.getMessage());
        }
        return new Binding(new String(stringBuffer), context);
    }

    public Object next() {
        return this.nextElement();
    }

    private void getSyntaxDefs() throws NoSuchElementException {
        try {
            this.service.readSyntaxes(0, true, 0, this.iterationHandle, this.syntaxDefs.getHandle());
            this.entriesLeft = this.syntaxDefs.getSyntaxCount();
            return;
        }
        catch (Exception exception) {
            throw new NoSuchElementException(exception.getMessage());
        }
    }

    public void close() throws NamingException {
        try {
            this.iterationHandle.closeIteration();
            return;
        }
        catch (NSIException nSIException) {
            NamingException namingException = exceptionFactory.getNamingException(nSIException);
            throw namingException;
        }
    }
}

