/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.nw;

import com.novell.service.nw.NetWareInitialContextBindingEnumerator;
import com.novell.service.nw.NetWareInitialContextNameClassEnumerator;
import com.novell.service.nw.NetWareNameParser;
import com.novell.service.nw.NetWareObjectFactory;
import com.sun.jndi.toolkit.ctx.AtomicContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.ctx.HeadTail;
import com.sun.jndi.toolkit.ctx.StringHeadTail;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class NetWareInitialContext
extends AtomicContext {
    protected Hashtable environment;
    private static NetWareNameParser parser;
    private Vector bindings;

    protected NetWareInitialContext(Hashtable hashtable) {
        this.environment = hashtable;
        if (parser == null) {
            parser = new NetWareNameParser();
        }
    }

    protected NetWareInitialContext(Hashtable hashtable, boolean bl) {
        this(hashtable);
        this.bindings = new Vector();
        this.bindings.addElement("Trees");
        this.bindings.addElement("Servers");
    }

    public String getNameInNamespace() throws NamingException {
        return "[Root]";
    }

    protected HeadTail p_parseComponent(Name name, Continuation continuation) throws NamingException {
        if (name.size() < 3) {
            return new HeadTail(name, null);
        }
        return new HeadTail(name.getPrefix(2), name.getSuffix(2));
    }

    protected StringHeadTail c_parseComponent(String string, Continuation continuation) throws NamingException {
        try {
            Name name = parser.parse(string);
            if (name.isEmpty() || name.size() == 1) {
                return new StringHeadTail(string, null);
            }
            Name name2 = name.getPrefix(1);
            Name name3 = name.getSuffix(1);
            return new StringHeadTail(name2.toString(), name3.toString());
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    protected Object a_lookup(String string, Continuation continuation) throws NamingException {
        if (this.isEmpty(string)) {
            continuation.setSuccess();
            return this;
        }
        try {
            Object object = new NetWareObjectFactory().getObjectInstance((Object)string, (Name)null, (Context)null, this.environment);
            if (object == null) {
                throw new NameNotFoundException();
            }
            continuation.setSuccess();
            return object;
        }
        catch (Exception exception) {
            continuation.setError((Object)this, string);
            NameNotFoundException nameNotFoundException = new NameNotFoundException();
            nameNotFoundException.setRootCause(exception);
            throw continuation.fillInException(nameNotFoundException);
        }
    }

    protected Object a_lookupLink(String string, Continuation continuation) throws NamingException {
        return this.a_lookup(string, continuation);
    }

    protected NamingEnumeration a_list(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new NetWareInitialContextNameClassEnumerator(this.bindings);
    }

    protected NamingEnumeration a_listBindings(Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return new NetWareInitialContextBindingEnumerator(this.bindings, this.getEnvironment());
    }

    protected void a_bind(String string, Object object, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_rebind(String string, Object object, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_unbind(String string, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_rename(String string, Name name, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected void a_destroySubcontext(String string, Continuation continuation) throws NamingException {
        this.notSupported(string, continuation);
    }

    protected Context a_createSubcontext(String string, Continuation continuation) throws NamingException {
        return (Context)this.notSupported(string, continuation);
    }

    protected NameParser a_getNameParser(Continuation continuation) throws NamingException {
        return parser;
    }

    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.environment.put(string, object);
    }

    public Object removeFromEnvironment(String string) throws NamingException {
        return this.environment.remove(string);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    public void close() throws NamingException {
    }

    private Object notSupported(String string, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, string);
        throw continuation.fillInException(new OperationNotSupportedException());
    }
}

