/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.server;

import com.novell.service.jncp.NSIException;
import com.novell.service.jncp.NSIExceptionBuilder;
import com.novell.service.rfc1960.SearchStringComponent;
import com.novell.service.server.CNWFSEFileServerInfo;
import com.novell.service.server.CVersionInfo;
import com.novell.service.server.ServerCounts;
import com.novell.service.session.Session;
import com.novell.service.session.xplat.CallsService;
import com.novell.utility.naming.directory.StaticAttributeValue;
import java.util.NoSuchElementException;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeModificationException;
import javax.naming.directory.BasicAttribute;

public class ServerCountsImpl
implements StaticAttributeValue,
ServerCounts {
    private int numberOfNCPRequests;
    private short maxConnections;
    private short maxConnectionsUsed;
    private short connectionsInUse;
    private short maxVolumes;
    private byte SFTLevel;
    private byte TTSLevel;
    private boolean empty1 = true;
    private boolean empty2 = true;
    private Session session;

    public ServerCountsImpl() {
    }

    protected ServerCountsImpl(Session session) {
        this.session = session;
    }

    public int getNumberOfNCPRequests() throws NSIException {
        if (this.empty1) {
            this.getFileServerInfo();
        }
        return this.numberOfNCPRequests;
    }

    public short getMaxConnections() throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        return this.maxConnections;
    }

    public short getMaxConnectionsUsed() throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        return this.maxConnectionsUsed;
    }

    public short getConnectionsInUse() throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        return this.connectionsInUse;
    }

    public short getMaxVolumes() throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        return this.maxVolumes;
    }

    public byte getSFTLevel() throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        return this.SFTLevel;
    }

    public byte getTTSLevel() throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        return this.TTSLevel;
    }

    public void setNumberOfNCPRequests(int n) throws NSIException {
        if (this.empty1) {
            this.getFileServerInfo();
        }
        this.numberOfNCPRequests = n;
    }

    public void setMaxConnections(short s) throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        this.maxConnections = s;
    }

    public void setMaxConnectionsUsed(short s) throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        this.maxConnectionsUsed = s;
    }

    public void setConnectionsInUse(short s) throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        this.connectionsInUse = s;
    }

    public void setMaxVolumes(short s) throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        this.maxVolumes = s;
    }

    public void setSFTLevel(byte by) throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        this.SFTLevel = by;
    }

    public void setTTSLevel(byte by) throws NSIException {
        if (this.empty2) {
            this.getFileServerVersionInfo();
        }
        this.TTSLevel = by;
    }

    private void getFileServerInfo() throws NSIException {
        this.empty1 = false;
        if (this.session == null) {
            return;
        }
        CNWFSEFileServerInfo cNWFSEFileServerInfo = new CNWFSEFileServerInfo();
        try {
            ((CallsService)this.session.getService("com.novell.service.session.xplat.CallsService.4461766964")).getFileServerInfo(cNWFSEFileServerInfo);
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
        this.numberOfNCPRequests = cNWFSEFileServerInfo.numOfNCPRequests;
    }

    private void getFileServerVersionInfo() throws NSIException {
        this.empty2 = false;
        if (this.session == null) {
            return;
        }
        CVersionInfo cVersionInfo = new CVersionInfo();
        try {
            ((CallsService)this.session.getService("com.novell.service.session.xplat.CallsService.4461766964")).getFileServerVersionInfo(cVersionInfo);
        }
        catch (Exception exception) {
            throw NSIExceptionBuilder.build(exception);
        }
        this.maxConnections = (short)cVersionInfo.iMaximumConnections;
        this.maxConnectionsUsed = (short)cVersionInfo.iMaxConnectionsEverUsed;
        this.connectionsInUse = (short)cVersionInfo.iConnectionsInUse;
        this.maxVolumes = (short)cVersionInfo.iMaxVolumes;
        this.SFTLevel = (byte)cVersionInfo.iSFTLevel;
        this.TTSLevel = (byte)cVersionInfo.iTTSLevel;
    }

    public Attribute buildAttribute() throws NamingException {
        return new BasicAttribute("ServerCounts", this);
    }

    public String getID() {
        return "ServerCounts";
    }

    public boolean compare(SearchStringComponent searchStringComponent) throws NamingException {
        int n = searchStringComponent.getOperationType();
        if (n == 4) {
            return true;
        }
        if (n == 0) {
            return this.equals(searchStringComponent.getReplacementObject());
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ServerCountsImpl)) {
            return false;
        }
        ServerCountsImpl serverCountsImpl = (ServerCountsImpl)object;
        if (serverCountsImpl == this) {
            return true;
        }
        try {
            if (this.empty1) {
                this.getFileServerInfo();
            }
            if (this.empty2) {
                this.getFileServerVersionInfo();
            }
            return this.numberOfNCPRequests == serverCountsImpl.getNumberOfNCPRequests() && this.maxConnections == serverCountsImpl.getMaxConnections() && this.maxConnectionsUsed == serverCountsImpl.getMaxConnectionsUsed() && this.connectionsInUse == serverCountsImpl.getConnectionsInUse() && this.maxVolumes == serverCountsImpl.getMaxVolumes() && this.SFTLevel == serverCountsImpl.getSFTLevel() && this.TTSLevel == serverCountsImpl.getTTSLevel();
        }
        catch (NSIException nSIException) {
            return false;
        }
    }

    public void addAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void deleteAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public void modifyAttribute(Attribute attribute) throws NamingException {
        throw new AttributeModificationException();
    }

    public boolean hasMoreElements() {
        return false;
    }

    public Object nextElement() {
        throw new NoSuchElementException();
    }

    public Object getStaticInterface() {
        return this;
    }
}

