/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.spi;

import com.novell.java.security.Identity;
import com.novell.service.session.InvalidStateException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionRuntimeException;
import com.novell.service.session.SessionService;
import com.novell.service.session.spi.Children;
import com.novell.service.session.spi.InvalidSessionState;
import com.novell.service.session.spi.SessionState;
import com.novell.service.session.util.JVMUID;
import java.rmi.server.UID;

public class SessionImpl
implements Session {
    private static final boolean DEBUG = false;
    private static final boolean LOCK_DEBUG = false;
    private static final boolean ENTRY_DEBUG = false;
    private static final boolean EXIT_DEBUG = false;
    private static final boolean OPEN_CLOSE_DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean METHOD_TRACE_DEBUG = false;
    private static final boolean SERVICE_DEBUG = false;
    private static final boolean SESSION_DEBUG = false;
    private static final boolean ERROR_ON_DEPRECATED = false;
    protected SessionState state = InvalidSessionState.getInstance();
    protected UID uid;
    protected SessionEnv environment;
    protected Session parent;
    protected String domainName;
    protected Children children;
    private Thread owner;
    private int lockCount;

    public SessionImpl(Session session, String string) throws SessionException {
        this(session, string, new SessionEnv());
    }

    public SessionImpl(Session session, String string, SessionEnv sessionEnv) throws SessionException {
        this.environment = sessionEnv;
        this.parent = session;
        this.domainName = string;
        this.children = new Children();
        JVMUID jVMUID = JVMUID.getInstance();
        this.uid = jVMUID.createUID();
    }

    public void setState(SessionState sessionState) throws SessionException {
        this.state = sessionState;
    }

    public SessionState getState() {
        this.lock();
        try {
            SessionState sessionState = this.state;
            Object var3_2 = null;
            this.unlock();
            return sessionState;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public String getDomainName() throws SessionException {
        this.lock();
        try {
            String string = this.domainName;
            Object var3_2 = null;
            this.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void close() throws SessionException {
        this.lock();
        try {
            this.getState().close();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
        Object var2_1 = null;
        this.unlock();
    }

    public Session getSession(String string) throws SessionException {
        this.lock();
        try {
            Session session;
            Session session2 = session = this.getSession(string, new SessionEnv());
            Object var4_4 = null;
            this.unlock();
            return session2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Session getSession(String string, SessionEnv sessionEnv) throws SessionException {
        this.lock();
        try {
            Session session;
            Session session2 = session = this.getState().getSession(string, sessionEnv);
            Object var5_5 = null;
            this.unlock();
            return session2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Session getSessionTop(String string) throws SessionException {
        this.lock();
        try {
            Session session;
            Session session2 = session = this.getSessionTop(string, new SessionEnv());
            Object var4_4 = null;
            this.unlock();
            return session2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Session getSessionTop(String string, SessionEnv sessionEnv) throws SessionException {
        this.lock();
        try {
            Session session;
            Session session2 = session = this.getState().getSessionTop(string, sessionEnv);
            Object var5_5 = null;
            this.unlock();
            return session2;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.unlock();
            throw throwable;
        }
    }

    public SessionAttrs getAttributes() throws SessionException {
        this.lock();
        try {
            SessionAttrs sessionAttrs = this.getState().getAttributes();
            String[] stringArray = new String[]{"IS_AUTHENTICATED_STATE", "UID"};
            sessionAttrs.modify(this.getImplAttrs(stringArray));
            SessionAttrs sessionAttrs2 = sessionAttrs;
            Object var3_4 = null;
            this.unlock();
            return sessionAttrs2;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        this.lock();
        try {
            SessionAttrs sessionAttrs = this.getImplAttrs(stringArray);
            if (sessionAttrs.count() != stringArray.length) {
                sessionAttrs.merge(this.getState().getAttributes(stringArray));
            }
            SessionAttrs sessionAttrs2 = sessionAttrs;
            Object var4_4 = null;
            this.unlock();
            return sessionAttrs2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    private SessionAttrs getImplAttrs(String[] stringArray) throws SessionException {
        this.lock();
        try {
            SessionAttrs sessionAttrs = new SessionAttrs();
            int n = 0;
            while (n < stringArray.length) {
                if ("IS_AUTHENTICATED_STATE".equals(stringArray[n])) {
                    sessionAttrs.modify("IS_AUTHENTICATED_STATE", new Boolean(this.isAuthenticated()));
                }
                if ("UID".equals(stringArray[n])) {
                    sessionAttrs.modify("UID", this.uid.toString());
                }
                ++n;
            }
            SessionAttrs sessionAttrs2 = sessionAttrs;
            Object var4_5 = null;
            this.unlock();
            return sessionAttrs2;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this.unlock();
            throw throwable;
        }
    }

    public SessionEnv getEnvironment() throws SessionException {
        this.lock();
        try {
            SessionEnv sessionEnv;
            SessionEnv sessionEnv2 = sessionEnv = (SessionEnv)this.environment.clone();
            Object var3_3 = null;
            this.unlock();
            return sessionEnv2;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public SessionEnv getEffectiveEnvironment() throws SessionException {
        this.lock();
        try {
            SessionEnv sessionEnv = (SessionEnv)this.environment.clone();
            try {
                if (this.hasParent()) {
                    sessionEnv.merge(this.getParent().getEffectiveEnvironment());
                }
            }
            catch (InvalidStateException invalidStateException) {
                // empty catch block
            }
            SessionEnv sessionEnv2 = sessionEnv;
            Object var3_4 = null;
            this.unlock();
            return sessionEnv2;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    public SessionEnv setEnvironment(SessionEnv sessionEnv) throws SessionException {
        this.lock();
        try {
            SessionEnv sessionEnv2 = this.environment;
            this.environment = (SessionEnv)sessionEnv.clone();
            SessionEnv sessionEnv3 = sessionEnv2;
            Object var4_4 = null;
            this.unlock();
            return sessionEnv3;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    public SessionEnumerator search(SessionAttrs sessionAttrs) throws SessionException {
        this.lock();
        try {
            SessionEnumerator sessionEnumerator;
            SessionEnumerator sessionEnumerator2 = sessionEnumerator = this.getState().search(sessionAttrs);
            Object var4_4 = null;
            this.unlock();
            return sessionEnumerator2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    public SessionEnumerator getChildren() throws SessionException {
        this.lock();
        try {
            SessionEnumerator sessionEnumerator;
            SessionEnumerator sessionEnumerator2 = sessionEnumerator = new SessionEnumerator(this.children.sessions());
            Object var3_3 = null;
            this.unlock();
            return sessionEnumerator2;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Session getParent() {
        return this.parent;
    }

    protected void invalidateSelf(Throwable throwable) throws SessionException {
        this.lock();
        try {
            if (this.hasParent()) {
                ((SessionImpl)this.getParent()).removeChild(this);
            }
            new InvalidSessionState(this, throwable);
        }
        catch (Throwable throwable2) {
            Object var3_3 = null;
            this.unlock();
            throw throwable2;
        }
        Object var3_2 = null;
        this.unlock();
    }

    public void invalidate(Throwable throwable) throws SessionException {
        this.lock();
        try {
            SessionImpl sessionImpl = this;
            try {
                SessionEnumerator sessionEnumerator = sessionImpl.getChildren();
                while (sessionEnumerator.hasMoreElements()) {
                    sessionEnumerator.next().invalidate(throwable);
                }
                sessionImpl.invalidateSelf(throwable);
            }
            catch (Exception exception) {
            }
            Object var3_5 = null;
            this.unlock();
            return;
        }
        catch (Throwable throwable2) {
            Object var3_6 = null;
            this.unlock();
            throw throwable2;
        }
    }

    public void validateLinks() throws SessionException {
        this.lock();
        try {
            this.getState().validateLinks();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
        Object var2_1 = null;
        this.unlock();
    }

    public boolean isValid() {
        this.lock();
        try {
            boolean bl = this.getState().isValid();
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public SessionService getService(String string) throws SessionException {
        this.lock();
        try {
            SessionService sessionService;
            SessionService sessionService2 = sessionService = this.getState().getService(string);
            Object var4_4 = null;
            this.unlock();
            return sessionService2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    public UID getUID() {
        this.lock();
        try {
            UID uID = this.uid;
            Object var3_2 = null;
            this.unlock();
            return uID;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public boolean hasChildren() {
        this.lock();
        try {
            boolean bl = !this.children.isEmpty();
            Object var3_2 = null;
            this.unlock();
            return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void addChild(SessionImpl sessionImpl) throws SessionException {
        this.lock();
        try {
            this.children.addChild(sessionImpl);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        Object var3_2 = null;
        this.unlock();
    }

    public void removeChild(SessionImpl sessionImpl) throws SessionException {
        this.lock();
        try {
            this.children.removeChild(sessionImpl);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        Object var3_2 = null;
        this.unlock();
    }

    public Session getChild(String string) throws SessionException {
        this.lock();
        try {
            SessionImpl sessionImpl = this.children.get(string);
            Object var4_3 = null;
            this.unlock();
            return sessionImpl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public String getName() throws SessionException {
        this.lock();
        try {
            String string;
            String string2 = string = this.getState().getName();
            Object var3_3 = null;
            this.unlock();
            return string2;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public void authenticate(String string) throws SessionException {
        this.lock();
        try {
            this.getState().authenticate(string);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.unlock();
            throw throwable;
        }
        Object var3_2 = null;
        this.unlock();
    }

    public void authenticate() throws SessionException {
        this.lock();
        try {
            this.getState().authenticate();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
        Object var2_1 = null;
        this.unlock();
    }

    public void unauthenticate() throws SessionException {
        this.lock();
        try {
            this.getState().unauthenticate();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.unlock();
            throw throwable;
        }
        Object var2_1 = null;
        this.unlock();
    }

    public boolean isAuthenticated() throws SessionException {
        this.lock();
        try {
            boolean bl;
            boolean bl2 = bl = this.getState().isAuthenticated();
            Object var3_3 = null;
            this.unlock();
            return bl2;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Identity createIdentity(String string) throws SessionException {
        this.lock();
        try {
            Identity identity;
            Identity identity2 = identity = this.getState().createIdentity(string);
            Object var4_4 = null;
            this.unlock();
            return identity2;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.unlock();
            throw throwable;
        }
    }

    public String toString() {
        this.lock();
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("SessionImpl$:U=" + this.uid);
            try {
                try {
                    stringBuffer.append(":" + this.domainName);
                }
                catch (Exception exception) {
                }
                Object var6_3 = null;
                stringBuffer.append(":" + this.state);
            }
            catch (Throwable throwable) {
                Object var6_4 = null;
                stringBuffer.append(":" + this.state);
                throw throwable;
            }
            String string = stringBuffer.toString();
            Object var3_7 = null;
            this.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Session findSession(String string) throws SessionException {
        this.lock();
        try {
            Session session = this.getState().findSession(string);
            Object var4_3 = null;
            this.unlock();
            return session;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    public Session findSessionTop(String string) throws SessionException {
        this.lock();
        try {
            Session session = this.getState().findSessionTop(string);
            Object var4_3 = null;
            this.unlock();
            return session;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.unlock();
            throw throwable;
        }
    }

    protected void lock() {
        if (this.parent != null) {
            ((SessionImpl)this.parent).lock();
            return;
        }
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            try {
                while (!this.tryLock()) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                throw new SessionRuntimeException("Interrupted");
            }
            return;
        }
    }

    private boolean tryLock() {
        if (this.owner == null) {
            this.owner = Thread.currentThread();
            this.lockCount = 1;
            return true;
        }
        if (this.owner == Thread.currentThread()) {
            ++this.lockCount;
            return true;
        }
        return false;
    }

    protected void unlock() {
        if (this.parent != null) {
            ((SessionImpl)this.parent).unlock();
            return;
        }
        SessionImpl sessionImpl = this;
        synchronized (sessionImpl) {
            if (this.owner != Thread.currentThread()) {
                throw new SessionRuntimeException("Not current lock owner");
            }
            if (--this.lockCount <= 0) {
                this.owner = null;
                this.notify();
            }
            return;
        }
    }
}

