/*
 * Decompiled with CFR 0.152.
 */
package com.novell.service.session.spi;

import com.novell.service.session.InvalidDomainNameException;
import com.novell.service.session.Session;
import com.novell.service.session.SessionAttrs;
import com.novell.service.session.SessionEnumerator;
import com.novell.service.session.SessionEnv;
import com.novell.service.session.SessionException;
import com.novell.service.session.SessionManager;
import com.novell.service.session.spi.InitialSessionFactory;
import com.novell.service.session.spi.SessionImpl;
import com.novell.service.session.spi.SessionManagerImpl;
import com.novell.service.session.spi.SessionState;
import com.novell.service.session.xplat.XplatUtil;
import java.util.StringTokenizer;
import java.util.Vector;

public class SessionManagerState
extends SessionState {
    private static final boolean DEBUG = false;
    private static final boolean I_DEBUG = false;
    private static final boolean S_DEBUG = false;
    private static final boolean FAIL_DEBUG = false;

    public SessionManagerState(SessionManager sessionManager) throws SessionException {
        super((SessionImpl)((Object)sessionManager));
        this.attachedSession.setState(this);
    }

    public Session getSession(String string, SessionEnv sessionEnv) throws SessionException {
        Session session = null;
        session = this.findSession(string);
        if (session == null) {
            Vector<Exception> vector = new Vector<Exception>();
            SessionEnumerator sessionEnumerator = this.getChildren();
            while (session == null && sessionEnumerator.hasMoreElements()) {
                Session session2 = sessionEnumerator.next();
                try {
                    session = session2.getSession(string, sessionEnv);
                }
                catch (Exception exception) {
                    vector.addElement(exception);
                }
            }
            if (session == null) {
                InvalidDomainNameException invalidDomainNameException = new InvalidDomainNameException(string);
                invalidDomainNameException.setRootCauses(vector);
                throw invalidDomainNameException;
            }
        }
        return session;
    }

    public Session getSessionTop(String string, SessionEnv sessionEnv) throws SessionException {
        return this.getSession(string, sessionEnv);
    }

    public SessionAttrs getAttributes() throws SessionException {
        SessionAttrs sessionAttrs = super.getAttributes();
        String[] stringArray = new String[]{"SESSION_TYPE", "IS_REAL", "SCOPE"};
        sessionAttrs.modify(this.getStateAttrs(stringArray));
        return sessionAttrs;
    }

    public SessionAttrs getAttributes(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = this.getStateAttrs(stringArray);
        if (sessionAttrs.count() != stringArray.length) {
            sessionAttrs.merge(super.getAttributes(stringArray));
        }
        return sessionAttrs;
    }

    private SessionAttrs getStateAttrs(String[] stringArray) throws SessionException {
        SessionAttrs sessionAttrs = new SessionAttrs();
        int n = 0;
        while (n < stringArray.length) {
            if ("SESSION_TYPE".equals(stringArray[n])) {
                sessionAttrs.modify("SESSION_TYPE", "SESSION_MANAGER");
            }
            if ("IS_REAL".equals(stringArray[n])) {
                sessionAttrs.add("IS_REAL", new Boolean(false));
            }
            if ("SCOPE".equals(stringArray[n])) {
                sessionAttrs.add("SCOPE", new Integer(((SessionManagerImpl)this.attachedSession).getScope()));
            }
            ++n;
        }
        return sessionAttrs;
    }

    protected void validateChildren() throws SessionException {
        if (!this.getChildren().hasMoreElements()) {
            String string = (String)this.getEffectiveEnvironment().get("com.novell.service.session.spi.InitialSessionFactory");
            if (string == null) {
                string = "com.novell.service.session.nds.NDSInitialSessionFactory:com.novell.service.session.bindery.BinderyInitialSessionFactory";
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                InitialSessionFactory initialSessionFactory = null;
                try {
                    String string2 = stringTokenizer.nextToken();
                    Class<?> clazz = Class.forName(string2);
                    initialSessionFactory = (InitialSessionFactory)clazz.newInstance();
                    SessionImpl sessionImpl = initialSessionFactory.getInitialSession((SessionManager)((Object)this.attachedSession));
                    this.attachedSession.addChild(sessionImpl);
                }
                catch (Exception exception) {
                    throw new SessionException(exception);
                }
            }
        }
    }

    public Session findSessionTop(String string) throws SessionException {
        return this.findSession(string);
    }

    protected synchronized void lock() {
        this.attachedSession.lock();
    }

    protected synchronized void unlock() {
        this.attachedSession.unlock();
    }

    protected void releaseResources() throws SessionException {
        super.releaseResources();
        if ((this.sessionManager.getScope() & 0x10000000) != 0) {
            XplatUtil.freePrivateInstance(this.sessionManager);
        }
    }
}

