/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.nmas.jndi.ldap.ext;

import com.sun.jndi.ldap.BerDecoder;
import java.io.IOException;
import javax.naming.NamingException;

public class GAMsLdapExtBerDecoder {
    private byte[] respBer;
    private int respOffset;
    private int respLength;
    private int nmasVersion;
    private int nmasRetCode;
    private int gamsIter = 0;
    private int gamsCount = 0;
    private int gamsHrlType = 0;
    private String gamsHrlString = null;
    private int gamsRangeType = 0;
    private String gamsReadHrl = null;
    private String gamsWriteHrl = null;
    private int hrlCompareResult = 0;

    public GAMsLdapExtBerDecoder(byte[] byArray, int n, int n2) {
        this.respBer = byArray;
        this.respOffset = n;
        this.respLength = n2;
    }

    void decodeGAMsDataResponse() throws NamingException {
        BerDecoder berDecoder = new BerDecoder(this.respBer, this.respOffset, this.respLength);
        try {
            int[] nArray = new int[1];
            int n = 0;
            int n2 = berDecoder.parseSeq(nArray);
            this.nmasVersion = berDecoder.parseInt();
            this.nmasRetCode = berDecoder.parseInt();
            this.nmasRetCode = this.fixRetCode(this.nmasRetCode);
            if (this.nmasRetCode == 0) {
                n = berDecoder.parseInt();
                switch (n) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        n2 = berDecoder.parseSeq(nArray);
                        this.gamsHrlType = berDecoder.parseInt();
                        this.gamsHrlString = berDecoder.parseString(true);
                        break;
                    }
                    case 3: {
                        break;
                    }
                    case 4: {
                        n2 = berDecoder.parseSeq(nArray);
                        this.gamsHrlType = berDecoder.parseInt();
                        this.gamsHrlString = berDecoder.parseString(true);
                        break;
                    }
                    case 5: {
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        n2 = berDecoder.parseSeq(nArray);
                        this.gamsRangeType = berDecoder.parseInt();
                        this.gamsReadHrl = berDecoder.parseString(true);
                        try {
                            this.gamsWriteHrl = berDecoder.parseString(true);
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    case 9: {
                        n2 = berDecoder.parseSeq(nArray);
                        this.gamsIter = berDecoder.parseInt();
                        if (this.gamsIter < 0) {
                            this.gamsIter = -1;
                        }
                        this.gamsRangeType = berDecoder.parseInt();
                        this.gamsReadHrl = berDecoder.parseString(true);
                        try {
                            this.gamsWriteHrl = berDecoder.parseString(true);
                        }
                        catch (IOException iOException) {}
                        break;
                    }
                    case 10: {
                        n2 = berDecoder.parseSeq(nArray);
                        this.gamsIter = berDecoder.parseInt();
                        if (this.gamsIter < 0) {
                            this.gamsIter = -1;
                        }
                        this.gamsHrlString = berDecoder.parseString(true);
                        break;
                    }
                    case 11: {
                        n2 = berDecoder.parseSeq(nArray);
                        this.gamsIter = berDecoder.parseInt();
                        if (this.gamsIter < 0) {
                            this.gamsIter = -1;
                        }
                        this.gamsCount = berDecoder.parseInt();
                        this.gamsHrlString = berDecoder.parseString(true);
                        break;
                    }
                    case 12: {
                        n2 = berDecoder.parseSeq(nArray);
                        this.hrlCompareResult = berDecoder.parseInt();
                        break;
                    }
                    case 13: {
                        break;
                    }
                    case 14: {
                        break;
                    }
                    default: {
                        throw new NamingException("Error BER decoding GAMs Response Data:  Invalid GAMs OP code");
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new NamingException("Error BER decoding GAMs Response Data: " + iOException.toString());
        }
    }

    public int getNmasVersion() {
        return this.nmasVersion;
    }

    public int getNmasRetCode() {
        return this.nmasRetCode;
    }

    public int getGamsIter() {
        return this.gamsIter;
    }

    public int getGamsCount() {
        return this.gamsCount;
    }

    public int getGamsHrlType() {
        return this.gamsHrlType;
    }

    public String getGamsHrlString() {
        return this.gamsHrlString;
    }

    public int getGamsRangeType() {
        return this.gamsRangeType;
    }

    public String getGamsReadHrl() {
        return this.gamsReadHrl;
    }

    public String getGamsWriteHrl() {
        return this.gamsWriteHrl;
    }

    public int getHrlCompareResult() {
        return this.hrlCompareResult;
    }

    private int fixRetCode(int n) {
        if (n >= -16054) {
            return n;
        }
        int n2 = n & Short.MAX_VALUE;
        return -1 * n2;
    }
}

