/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.nmas.mgmt;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.security.nmas.jldap.ext.Jldap_GAMsDataRequest;
import com.novell.security.nmas.mgmt.GamsException;
import com.novell.security.nmas.mgmt.GamsTransport;
import java.io.IOException;

public class GamsJLdapTransport
implements GamsTransport {
    private LDAPConnection ldapConn = null;

    public GamsJLdapTransport(LDAPConnection lDAPConnection) {
        this.ldapConn = lDAPConnection;
    }

    @Override
    public void setVolumeLabel(String string, int n, String string2) throws GamsException {
        block15: {
            if (string == null) {
                throw new GamsException(-1643);
            }
            if (string2 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(1, string, n, string2);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block15;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n2 = aSN1Integer2.intValue();
                    if (n2 != 0) {
                        throw new GamsException(n2);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n3 = aSN1Integer3.intValue();
                    if (n3 != 1) {
                        throw new GamsException(-1639);
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void getVolumeLabel(String string, int[] nArray, String[] stringArray) throws GamsException {
        block18: {
            if (nArray == null || stringArray == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(2, string);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block18;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new GamsException(n);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n2 = aSN1Integer3.intValue();
                    if (n2 != 2) {
                        throw new GamsException(-1639);
                    }
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(3);
                    if (aSN1Sequence2 == null) {
                        throw new IOException("Decoding error");
                    }
                    if (aSN1Sequence2.size() == 2) {
                        ASN1Integer aSN1Integer4 = (ASN1Integer)aSN1Sequence2.get(0);
                        if (aSN1Integer4 == null) {
                            throw new IOException("Decoding error");
                        }
                        nArray[0] = aSN1Integer4.intValue();
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence2.get(1);
                        if (aSN1OctetString == null) {
                            throw new IOException("Decoding error");
                        }
                        stringArray[0] = new String(aSN1OctetString.byteValue());
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void setTagLabel(String string, String string2, String string3, int n, String string4) throws GamsException {
        block14: {
            if (string == null || string2 == null || string3 == null || string4 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(3, string, string2, string3, n, string4);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block14;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n2 = aSN1Integer2.intValue();
                    if (n2 != 0) {
                        throw new GamsException(n2);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n3 = aSN1Integer3.intValue();
                    if (n3 != 3) {
                        throw new GamsException(-1639);
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void getTagLabel(String string, String string2, String string3, int[] nArray, String[] stringArray) throws GamsException {
        block18: {
            if (string == null || string2 == null || string3 == null || nArray == null || stringArray == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(4, string, string2, string3);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block18;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new GamsException(n);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n2 = aSN1Integer3.intValue();
                    if (n2 != 4) {
                        throw new GamsException(-1639);
                    }
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(3);
                    if (aSN1Sequence2 == null) {
                        throw new IOException("Decoding error");
                    }
                    if (aSN1Sequence2.size() == 2) {
                        ASN1Integer aSN1Integer4 = (ASN1Integer)aSN1Sequence2.get(0);
                        if (aSN1Integer4 == null) {
                            throw new IOException("Decoding error");
                        }
                        nArray[0] = aSN1Integer4.intValue();
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence2.get(1);
                        if (aSN1OctetString == null) {
                            throw new IOException("Decoding error");
                        }
                        stringArray[0] = new String(aSN1OctetString.byteValue());
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void setAuthRange(String string, String string2) throws GamsException {
        this.setAuthRange(string, 0, string2, null);
    }

    @Override
    public void setAuthRange(String string, int n, String string2, String string3) throws GamsException {
        block14: {
            if (string == null || string2 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(5, string, n, string2, string3);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block14;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n2 = aSN1Integer2.intValue();
                    if (n2 != 0) {
                        throw new GamsException(n2);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n3 = aSN1Integer3.intValue();
                    if (n3 != 5) {
                        throw new GamsException(-1639);
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void setDefaultRange(String string, String string2) throws GamsException {
        this.setDefaultRange(string, 0, string2, null);
    }

    @Override
    public void setDefaultRange(String string, int n, String string2, String string3) throws GamsException {
        block14: {
            if (string == null || string2 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(6, string, n, string2, string3);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block14;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n2 = aSN1Integer2.intValue();
                    if (n2 != 0) {
                        throw new GamsException(n2);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n3 = aSN1Integer3.intValue();
                    if (n3 != 6) {
                        throw new GamsException(-1639);
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void resetAuthRanges(String string) throws GamsException {
        block14: {
            if (string == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(7, string);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block14;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new GamsException(n);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n2 = aSN1Integer3.intValue();
                    if (n2 != 7) {
                        throw new GamsException(-1639);
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void getDefaultRange(String string, int[] nArray, String[] stringArray, String[] stringArray2) throws GamsException {
        block20: {
            if (string == null || stringArray == null || stringArray2 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(8, string);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block20;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new GamsException(n);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n2 = aSN1Integer3.intValue();
                    if (n2 != 8) {
                        throw new GamsException(-1639);
                    }
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(3);
                    if (aSN1Sequence2 == null) {
                        throw new IOException("Decoding error");
                    }
                    if (aSN1Sequence2.size() >= 2) {
                        ASN1Integer aSN1Integer4 = (ASN1Integer)aSN1Sequence2.get(0);
                        if (aSN1Integer4 == null) {
                            throw new IOException("Decoding error");
                        }
                        nArray[0] = aSN1Integer4.intValue();
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence2.get(1);
                        if (aSN1OctetString == null) {
                            throw new IOException("Decoding error");
                        }
                        stringArray[0] = new String(aSN1OctetString.byteValue());
                        if (aSN1Sequence2.size() == 3) {
                            ASN1OctetString aSN1OctetString2 = (ASN1OctetString)aSN1Sequence2.get(2);
                            if (aSN1OctetString2 == null) {
                                throw new IOException("Decoding error");
                            }
                            stringArray2[0] = new String(aSN1OctetString2.byteValue());
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void scanAuthRange(String string, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2) throws GamsException {
        block21: {
            if (string == null || stringArray == null || stringArray2 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(9, nArray[0], string);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block21;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new GamsException(n);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n2 = aSN1Integer3.intValue();
                    if (n2 != 9) {
                        throw new GamsException(-1639);
                    }
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(3);
                    if (aSN1Sequence2 == null) {
                        throw new IOException("Decoding error");
                    }
                    if (aSN1Sequence2.size() >= 3) {
                        ASN1Integer aSN1Integer4 = (ASN1Integer)aSN1Sequence2.get(0);
                        if (aSN1Integer4 == null) {
                            throw new IOException("Decoding error");
                        }
                        nArray[0] = aSN1Integer4.intValue();
                        ASN1Integer aSN1Integer5 = (ASN1Integer)aSN1Sequence2.get(1);
                        if (aSN1Integer5 == null) {
                            throw new IOException("Decoding error");
                        }
                        nArray2[0] = aSN1Integer5.intValue();
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence2.get(2);
                        if (aSN1OctetString == null) {
                            throw new IOException("Decoding error");
                        }
                        stringArray[0] = new String(aSN1OctetString.byteValue());
                        if (aSN1Sequence2.size() == 4) {
                            ASN1OctetString aSN1OctetString2 = (ASN1OctetString)aSN1Sequence2.get(3);
                            if (aSN1OctetString2 == null) {
                                throw new IOException("Decoding error");
                            }
                            stringArray2[0] = new String(aSN1OctetString2.byteValue());
                        }
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void scanHRLs(int n, int[] nArray, String[] stringArray) throws GamsException {
        block18: {
            if (nArray == null || stringArray == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(10, n, nArray[0]);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block18;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n2 = aSN1Integer2.intValue();
                    if (n2 != 0) {
                        throw new GamsException(n2);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n3 = aSN1Integer3.intValue();
                    if (n3 != 10) {
                        throw new GamsException(-1639);
                    }
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(3);
                    if (aSN1Sequence2 == null) {
                        throw new IOException("Decoding error");
                    }
                    if (aSN1Sequence2.size() == 2) {
                        ASN1Integer aSN1Integer4 = (ASN1Integer)aSN1Sequence2.get(0);
                        if (aSN1Integer4 == null) {
                            throw new IOException("Decoding error");
                        }
                        nArray[0] = aSN1Integer4.intValue();
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence2.get(1);
                        if (aSN1OctetString == null) {
                            throw new IOException("Decoding error");
                        }
                        stringArray[0] = new String(aSN1OctetString.byteValue());
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void hrlDefinition(int n, String string, int n2, int[] nArray, int[] nArray2, String[] stringArray) throws GamsException {
        block19: {
            if (string == null || nArray == null || nArray2 == null || stringArray == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(11, nArray[0], n, string, n2);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block19;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n3 = aSN1Integer2.intValue();
                    if (n3 != 0) {
                        throw new GamsException(n3);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n4 = aSN1Integer3.intValue();
                    if (n4 != 11) {
                        throw new GamsException(-1639);
                    }
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(3);
                    if (aSN1Sequence2 == null) {
                        throw new IOException("Decoding error");
                    }
                    if (aSN1Sequence2.size() == 3) {
                        ASN1Integer aSN1Integer4 = (ASN1Integer)aSN1Sequence2.get(0);
                        if (aSN1Integer4 == null) {
                            throw new IOException("Decoding error");
                        }
                        nArray[0] = aSN1Integer4.intValue();
                        ASN1Integer aSN1Integer5 = (ASN1Integer)aSN1Sequence2.get(1);
                        if (aSN1Integer5 == null) {
                            throw new IOException("Decoding error");
                        }
                        nArray2[0] = aSN1Integer5.intValue();
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence2.get(2);
                        if (aSN1OctetString == null) {
                            throw new IOException("Decoding error");
                        }
                        stringArray[0] = new String(aSN1OctetString.byteValue());
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public int hrlCompare(int n, String string, int n2, String string2) throws GamsException {
        int n3;
        block16: {
            n3 = 0;
            if (string == null || string2 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(12, n, string, n2, string2);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block16;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n4 = aSN1Integer3.intValue();
                    if (n4 != 12) {
                        throw new GamsException(-1639);
                    }
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)aSN1Sequence.get(3);
                    if (aSN1Sequence2 == null) {
                        throw new IOException("Decoding error");
                    }
                    if (aSN1Sequence2.size() == 3) {
                        ASN1Integer aSN1Integer4 = (ASN1Integer)aSN1Sequence.get(1);
                        if (aSN1Integer4 == null) {
                            throw new IOException("Decoding error");
                        }
                        n3 = aSN1Integer2.intValue();
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
        return n3;
    }

    @Override
    public void defineHRL(String string, int n, int n2, String string2, String string3) throws GamsException {
        block14: {
            if (string == null || string2 == null || string3 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(13, string, n, n2, string2, string3);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block14;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n3 = aSN1Integer2.intValue();
                    if (n3 != 0) {
                        throw new GamsException(n3);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n4 = aSN1Integer3.intValue();
                    if (n4 != 13) {
                        throw new GamsException(-1639);
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void deleteHRL(String string, int n, int n2, String string2) throws GamsException {
        block14: {
            if (string == null || string2 == null) {
                throw new GamsException(-1643);
            }
            if (this.ldapConn == null) {
                throw new GamsException(-1681);
            }
            try {
                Jldap_GAMsDataRequest jldap_GAMsDataRequest = new Jldap_GAMsDataRequest(14, string, n, n2, string2);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GAMsDataRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) break block14;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new GamsException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new GamsException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n3 = aSN1Integer2.intValue();
                    if (n3 != 0) {
                        throw new GamsException(n3);
                    }
                    ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
                    if (aSN1Integer3 == null) {
                        throw new IOException("GAMS OP Decoding error");
                    }
                    int n4 = aSN1Integer3.intValue();
                    if (n4 != 14) {
                        throw new GamsException(-1639);
                    }
                }
                catch (IOException iOException) {
                    throw new GamsException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new GamsException(lDAPException.toString(), -1681);
            }
        }
    }
}

