/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.nmas.mgmt;

import com.novell.security.nmas.jndi.ldap.ext.GAMsDataRequest;
import com.novell.security.nmas.jndi.ldap.ext.GAMsDataResponse;
import com.novell.security.nmas.mgmt.GamsException;
import com.novell.security.nmas.mgmt.GamsTransport;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;

public class GamsLdapTransport
implements GamsTransport {
    private LdapContext ldapCtx;

    public GamsLdapTransport(LdapContext ldapContext) {
        this.ldapCtx = ldapContext;
    }

    @Override
    public void setVolumeLabel(String string, int n, String string2) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string2 == null) {
            throw new GamsException(-1643);
        }
        try {
            int n2;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(1, string, n, string2);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n2 = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n2);
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void getVolumeLabel(String string, int[] nArray, String[] stringArray) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (nArray == null || stringArray == null) {
            throw new GamsException(-1643);
        }
        try {
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(2, string);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) {
                int n = gAMsDataResponse.getNmasRetCode();
                if (n != 0) {
                    throw new GamsException(n);
                }
                nArray[0] = gAMsDataResponse.getGamsHrlType();
                stringArray[0] = gAMsDataResponse.getGamsHrlString();
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void setTagLabel(String string, String string2, String string3, int n, String string4) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new GamsException(-1643);
        }
        try {
            int n2;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(3, string, string2, string3, n, string4);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n2 = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n2);
            }
        }
        catch (NamingException namingException) {
            namingException.printStackTrace();
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void getTagLabel(String string, String string2, String string3, int[] nArray, String[] stringArray) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null || string3 == null || nArray == null || stringArray == null) {
            throw new GamsException(-1643);
        }
        try {
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(4, string, string2, string3);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) {
                int n = gAMsDataResponse.getNmasRetCode();
                if (n != 0) {
                    throw new GamsException(n);
                }
                nArray[0] = gAMsDataResponse.getGamsHrlType();
                stringArray[0] = gAMsDataResponse.getGamsHrlString();
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void setAuthRange(String string, String string2) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null) {
            throw new GamsException(-1643);
        }
        try {
            int n;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(5, string, string2);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n);
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void setAuthRange(String string, int n, String string2, String string3) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null) {
            throw new GamsException(-1643);
        }
        try {
            int n2;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(5, string, n, string2, string3);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n2 = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n2);
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void setDefaultRange(String string, String string2) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null) {
            throw new GamsException(-1643);
        }
        try {
            int n;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(6, string, string2);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n);
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void setDefaultRange(String string, int n, String string2, String string3) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null) {
            throw new GamsException(-1643);
        }
        try {
            int n2;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(6, string, n, string2, string3);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n2 = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n2);
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void resetAuthRanges(String string) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null) {
            throw new GamsException(-1643);
        }
        try {
            int n;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(7, string);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n);
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void getDefaultRange(String string, int[] nArray, String[] stringArray, String[] stringArray2) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || nArray == null || stringArray == null || stringArray2 == null) {
            throw new GamsException(-1643);
        }
        try {
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(8, string);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) {
                int n = gAMsDataResponse.getNmasRetCode();
                if (n != 0) {
                    throw new GamsException(n);
                }
                nArray[0] = gAMsDataResponse.getGamsRangeType();
                stringArray[0] = gAMsDataResponse.getGamsReadHrl();
                stringArray2[0] = gAMsDataResponse.getGamsWriteHrl();
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void scanAuthRange(String string, int[] nArray, int[] nArray2, String[] stringArray, String[] stringArray2) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || nArray == null || nArray2 == null || stringArray == null || stringArray2 == null) {
            throw new GamsException(-1643);
        }
        try {
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(9, nArray[0], string);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) {
                int n = gAMsDataResponse.getNmasRetCode();
                if (n != 0) {
                    throw new GamsException(n);
                }
                nArray[0] = gAMsDataResponse.getGamsIter();
                nArray2[0] = gAMsDataResponse.getGamsRangeType();
                stringArray[0] = gAMsDataResponse.getGamsReadHrl();
                stringArray2[0] = gAMsDataResponse.getGamsWriteHrl();
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void scanHRLs(int n, int[] nArray, String[] stringArray) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (nArray == null || stringArray == null) {
            throw new GamsException(-1643);
        }
        try {
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(10, n, nArray[0]);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) {
                int n2 = gAMsDataResponse.getNmasRetCode();
                if (n2 != 0) {
                    throw new GamsException(n2);
                }
                nArray[0] = gAMsDataResponse.getGamsIter();
                stringArray[0] = gAMsDataResponse.getGamsHrlString();
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void hrlDefinition(int n, String string, int n2, int[] nArray, int[] nArray2, String[] stringArray) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || nArray == null || nArray2 == null || stringArray == null) {
            throw new GamsException(-1643);
        }
        try {
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(11, nArray[0], n, string, n2);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) {
                int n3 = gAMsDataResponse.getNmasRetCode();
                if (n3 != 0) {
                    throw new GamsException(n3);
                }
                nArray[0] = gAMsDataResponse.getGamsIter();
                nArray2[0] = gAMsDataResponse.getGamsCount();
                stringArray[0] = gAMsDataResponse.getGamsHrlString();
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public int hrlCompare(int n, String string, int n2, String string2) throws GamsException {
        int n3 = 0;
        int n4 = 0;
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null) {
            throw new GamsException(-1643);
        }
        try {
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(12, n, string, n2, string2);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24")) {
                n3 = gAMsDataResponse.getNmasRetCode();
                if (n3 != 0) {
                    throw new GamsException(n3);
                }
                n4 = gAMsDataResponse.getHrlCompareResult();
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
        return n4;
    }

    @Override
    public void defineHRL(String string, int n, int n2, String string2, String string3) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null || string3 == null) {
            throw new GamsException(-1643);
        }
        try {
            int n3;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(13, string, n, n2, string2, string3);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n3 = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n3);
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }

    @Override
    public void deleteHRL(String string, int n, int n2, String string2) throws GamsException {
        if (this.ldapCtx == null) {
            throw new GamsException(-1681);
        }
        if (string == null || string2 == null) {
            throw new GamsException(-1643);
        }
        try {
            int n3;
            GAMsDataRequest gAMsDataRequest = new GAMsDataRequest(14, string, n, n2, string2);
            GAMsDataResponse gAMsDataResponse = (GAMsDataResponse)this.ldapCtx.extendedOperation(gAMsDataRequest);
            if (gAMsDataResponse.getID().equals("2.16.840.1.113719.1.39.42.100.24") && (n3 = gAMsDataResponse.getNmasRetCode()) != 0) {
                throw new GamsException(n3);
            }
        }
        catch (NamingException namingException) {
            throw new GamsException(namingException.toString(), -1681);
        }
    }
}

