/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.nmas.mgmt;

import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPExtendedOperation;
import com.novell.ldap.LDAPExtendedResponse;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.ldap.extensions.LDAPDnsToX500DNRequest;
import com.novell.ldap.extensions.LDAPDnsToX500DNResponse;
import com.novell.security.nmas.jldap.ext.Jldap_ChangePwdRequest;
import com.novell.security.nmas.jldap.ext.Jldap_DeletePwdRequest;
import com.novell.security.nmas.jldap.ext.Jldap_GetPwdPolicyInfoRequest;
import com.novell.security.nmas.jldap.ext.Jldap_GetPwdRequest;
import com.novell.security.nmas.jldap.ext.Jldap_GetPwdStatusRequest;
import com.novell.security.nmas.jldap.ext.Jldap_PwdPolicyCheckRequest;
import com.novell.security.nmas.jldap.ext.Jldap_SetPwdRequest;
import com.novell.security.nmas.mgmt.NMASPwdException;
import com.novell.security.nmas.mgmt.NMASPwdStatus;
import com.novell.security.nmas.mgmt.PwdTransport;
import java.io.IOException;

public final class PwdJLdapTransport
implements PwdTransport {
    private LDAPConnection ldapConn = null;

    public PwdJLdapTransport(LDAPConnection lDAPConnection) {
        this.ldapConn = lDAPConnection;
    }

    @Override
    public void setPwd(String string, String string2, String string3) throws NMASPwdException {
        block11: {
            if (this.ldapConn == null) {
                throw new NMASPwdException(-1681);
            }
            try {
                Jldap_SetPwdRequest jldap_SetPwdRequest = new Jldap_SetPwdRequest(string, string2, string3);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_SetPwdRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.12")) break block11;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new NMASPwdException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new NMASPwdException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new NMASPwdException(n);
                    }
                }
                catch (IOException iOException) {
                    throw new NMASPwdException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new NMASPwdException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public String getPwd(String string, String string2) throws NMASPwdException {
        String string3;
        block13: {
            string3 = null;
            if (this.ldapConn == null) {
                throw new NMASPwdException(-1681);
            }
            try {
                Jldap_GetPwdRequest jldap_GetPwdRequest = new Jldap_GetPwdRequest(string, string2);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GetPwdRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.14")) break block13;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new NMASPwdException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new NMASPwdException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new NMASPwdException(n);
                    }
                    if (aSN1Sequence.size() == 3) {
                        ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence.get(2);
                        if (aSN1OctetString == null) {
                            throw new IOException("Decoding error");
                        }
                        string3 = new String(aSN1OctetString.byteValue(), "UTF8");
                    }
                }
                catch (IOException iOException) {
                    throw new NMASPwdException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new NMASPwdException(lDAPException.toString(), -1681);
            }
        }
        return string3;
    }

    @Override
    public void deletePwd(String string, String string2) throws NMASPwdException {
        block11: {
            if (this.ldapConn == null) {
                throw new NMASPwdException(-1681);
            }
            try {
                Jldap_DeletePwdRequest jldap_DeletePwdRequest = new Jldap_DeletePwdRequest(string, string2);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_DeletePwdRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.16")) break block11;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new NMASPwdException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new NMASPwdException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new NMASPwdException(n);
                    }
                }
                catch (IOException iOException) {
                    throw new NMASPwdException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new NMASPwdException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public void changePwd(String string, String string2, String string3, String string4) throws NMASPwdException {
        block11: {
            if (this.ldapConn == null) {
                throw new NMASPwdException(-1681);
            }
            try {
                Jldap_ChangePwdRequest jldap_ChangePwdRequest = new Jldap_ChangePwdRequest(string, string2, string3, string4);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_ChangePwdRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.22")) break block11;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new NMASPwdException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new NMASPwdException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new NMASPwdException(n);
                    }
                }
                catch (IOException iOException) {
                    throw new NMASPwdException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new NMASPwdException(lDAPException.toString(), -1681);
            }
        }
    }

    @Override
    public int pwdPolicyCheck(String string, String string2, String string3) throws NMASPwdException {
        int n;
        block11: {
            n = -1681;
            if (this.ldapConn == null) {
                throw new NMASPwdException(-1681);
            }
            try {
                Jldap_PwdPolicyCheckRequest jldap_PwdPolicyCheckRequest = new Jldap_PwdPolicyCheckRequest(string, string2, string3);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_PwdPolicyCheckRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.18")) break block11;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new NMASPwdException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new NMASPwdException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new NMASPwdException(n);
                    }
                }
                catch (IOException iOException) {
                    throw new NMASPwdException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new NMASPwdException(lDAPException.toString(), -1681);
            }
        }
        return n;
    }

    @Override
    public NMASPwdStatus getPwdStatus(String string, String string2) throws NMASPwdException {
        int n = -1681;
        if (this.ldapConn == null) {
            throw new NMASPwdException(-1681);
        }
        try {
            Jldap_GetPwdStatusRequest jldap_GetPwdStatusRequest = new Jldap_GetPwdStatusRequest(string, string2);
            LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GetPwdStatusRequest);
            if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.18")) {
                throw new NMASPwdException(-1681);
            }
            byte[] byArray = lDAPExtendedResponse.getValue();
            if (byArray == null) {
                throw new NMASPwdException("No returned value", -1681);
            }
            LBERDecoder lBERDecoder = new LBERDecoder();
            if (lBERDecoder == null) {
                throw new NMASPwdException("Could not create the BER Decoder. ", -1681);
            }
            ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
            if (aSN1Sequence == null) {
                throw new NMASPwdException("Error decoding BER encoded data", -1681);
            }
            ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
            if (aSN1Integer == null) {
                throw new NMASPwdException("Error decoding BER encoded data", -1681);
            }
            ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
            if (aSN1Integer2 == null) {
                throw new NMASPwdException("Error decoding BER encoded data", -1681);
            }
            n = aSN1Integer2.intValue();
            if (n != 0) {
                throw new NMASPwdException(n);
            }
            ASN1Integer aSN1Integer3 = (ASN1Integer)aSN1Sequence.get(2);
            ASN1Integer aSN1Integer4 = (ASN1Integer)aSN1Sequence.get(3);
            if (aSN1Integer3 == null || aSN1Integer4 == null) {
                throw new NMASPwdException("Error decoding BER encoded data", -1681);
            }
            NMASPwdStatus nMASPwdStatus = new NMASPwdStatus();
            nMASPwdStatus.setUniversalPwdStatus(aSN1Integer3.intValue());
            nMASPwdStatus.setSimplePwdStatus(aSN1Integer4.intValue());
            return nMASPwdStatus;
        }
        catch (LDAPException lDAPException) {
            throw new NMASPwdException(lDAPException.toString(), -1681);
        }
    }

    @Override
    public String getPwdPolicyDN(String string, String string2) throws NMASPwdException {
        String string3;
        block12: {
            string3 = null;
            if (this.ldapConn == null) {
                throw new NMASPwdException(-1681);
            }
            try {
                Jldap_GetPwdPolicyInfoRequest jldap_GetPwdPolicyInfoRequest = new Jldap_GetPwdPolicyInfoRequest(string, string2);
                LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)jldap_GetPwdPolicyInfoRequest);
                if (!lDAPExtendedResponse.getID().equals("2.16.840.1.113719.1.39.42.100.20")) break block12;
                byte[] byArray = lDAPExtendedResponse.getValue();
                if (byArray == null) {
                    throw new NMASPwdException("No returned value", -1681);
                }
                try {
                    LBERDecoder lBERDecoder = new LBERDecoder();
                    if (lBERDecoder == null) {
                        throw new NMASPwdException("Could not create the BER Decoder. ", -1681);
                    }
                    ASN1Sequence aSN1Sequence = (ASN1Sequence)lBERDecoder.decode(byArray);
                    if (aSN1Sequence == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer = (ASN1Integer)aSN1Sequence.get(0);
                    if (aSN1Integer == null) {
                        throw new IOException("Decoding error");
                    }
                    ASN1Integer aSN1Integer2 = (ASN1Integer)aSN1Sequence.get(1);
                    if (aSN1Integer2 == null) {
                        throw new IOException("Decoding error");
                    }
                    int n = aSN1Integer2.intValue();
                    if (n != 0) {
                        throw new NMASPwdException(n);
                    }
                    ASN1OctetString aSN1OctetString = (ASN1OctetString)aSN1Sequence.get(2);
                    if (aSN1OctetString == null) {
                        throw new IOException("Decoding error");
                    }
                    string3 = new String(aSN1OctetString.byteValue(), "UTF8");
                }
                catch (IOException iOException) {
                    throw new NMASPwdException("Error decoding BER encoded data", -1681);
                }
            }
            catch (LDAPException lDAPException) {
                throw new NMASPwdException(lDAPException.toString(), -1681);
            }
        }
        return string3;
    }

    @Override
    public String dnsToX500DN(String string) throws NMASPwdException {
        if (this.ldapConn == null) {
            throw new NMASPwdException(-1681);
        }
        try {
            LDAPDnsToX500DNRequest lDAPDnsToX500DNRequest = new LDAPDnsToX500DNRequest(string);
            LDAPExtendedResponse lDAPExtendedResponse = this.ldapConn.extendedOperation((LDAPExtendedOperation)lDAPDnsToX500DNRequest);
            if (lDAPExtendedResponse.getResultCode() == 0 && lDAPExtendedResponse instanceof LDAPDnsToX500DNResponse) {
                return ((LDAPDnsToX500DNResponse)lDAPExtendedResponse).getX500DN();
            }
            throw new LDAPException(lDAPExtendedResponse.getErrorMessage(), lDAPExtendedResponse.getResultCode(), (String)null);
        }
        catch (LDAPException lDAPException) {
            throw new NMASPwdException(lDAPException.toString(), -1681);
        }
    }
}

