/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class ASN1Identifier
implements Cloneable {
    public static final int UNIVERSAL = 0;
    public static final int APPLICATION = 1;
    public static final int CONTEXT = 2;
    public static final int PRIVATE = 3;
    private int tagClass;
    private boolean constructed;
    private int tag;
    private int encodedLength;

    public ASN1Identifier(int n, boolean bl, int n2) {
        this.tagClass = n;
        this.constructed = bl;
        this.tag = n2;
    }

    public ASN1Identifier(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        ++this.encodedLength;
        if (n < 0) {
            throw new EOFException("BERDecoder: decode: EOF in Identifier");
        }
        this.tagClass = n >> 6;
        this.constructed = (n & 0x20) != 0;
        this.tag = n & 0x1F;
        if (this.tag == 31) {
            this.tag = this.decodeTagNumber(inputStream);
        }
    }

    public ASN1Identifier() {
    }

    public final void reset(InputStream inputStream) throws IOException {
        this.encodedLength = 0;
        int n = inputStream.read();
        ++this.encodedLength;
        if (n < 0) {
            throw new EOFException("BERDecoder: decode: EOF in Identifier");
        }
        this.tagClass = n >> 6;
        this.constructed = (n & 0x20) != 0;
        this.tag = n & 0x1F;
        if (this.tag == 31) {
            this.tag = this.decodeTagNumber(inputStream);
        }
    }

    private int decodeTagNumber(InputStream inputStream) throws IOException {
        int n;
        int n2 = 0;
        do {
            n = inputStream.read();
            ++this.encodedLength;
            if (n < 0) {
                throw new EOFException("BERDecoder: decode: EOF in tag number");
            }
            n2 = (n2 << 7) + (n & 0x7F);
        } while ((n & 0x80) != 0);
        return n2;
    }

    public final int getASN1Class() {
        return this.tagClass;
    }

    public final boolean getConstructed() {
        return this.constructed;
    }

    public final int getTag() {
        return this.tag;
    }

    public final int getEncodedLength() {
        return this.encodedLength;
    }

    public final boolean isUniversal() {
        return this.tagClass == 0;
    }

    public final boolean isApplication() {
        return this.tagClass == 1;
    }

    public final boolean isContext() {
        return this.tagClass == 2;
    }

    public final boolean isPrivate() {
        return this.tagClass == 3;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Internal error, cannot create clone");
        }
    }
}

