/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Encoder;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Object;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ASN1Structured
extends ASN1Object {
    private ASN1Object[] content;
    private int contentIndex = 0;

    protected ASN1Structured(ASN1Identifier aSN1Identifier) {
        this(aSN1Identifier, 10);
    }

    protected ASN1Structured(ASN1Identifier aSN1Identifier, int n) {
        super(aSN1Identifier);
        this.content = new ASN1Object[n];
    }

    protected ASN1Structured(ASN1Identifier aSN1Identifier, ASN1Object[] aSN1ObjectArray, int n) {
        super(aSN1Identifier);
        this.content = aSN1ObjectArray;
        this.contentIndex = n;
    }

    public final void encode(ASN1Encoder aSN1Encoder, OutputStream outputStream) throws IOException {
        aSN1Encoder.encode(this, outputStream);
    }

    protected final void decodeStructured(ASN1Decoder aSN1Decoder, InputStream inputStream, int n) throws IOException {
        int[] nArray = new int[1];
        while (n > 0) {
            this.add(aSN1Decoder.decode(inputStream, nArray));
            n -= nArray[0];
        }
    }

    public final ASN1Object[] toArray() {
        ASN1Object[] aSN1ObjectArray = new ASN1Object[this.contentIndex];
        System.arraycopy(this.content, 0, aSN1ObjectArray, 0, this.contentIndex);
        return aSN1ObjectArray;
    }

    public final void add(ASN1Object aSN1Object) {
        if (this.contentIndex == this.content.length) {
            int n = this.contentIndex + this.contentIndex;
            ASN1Object[] aSN1ObjectArray = new ASN1Object[n];
            System.arraycopy(this.content, 0, aSN1ObjectArray, 0, this.contentIndex);
            this.content = aSN1ObjectArray;
        }
        this.content[this.contentIndex++] = aSN1Object;
    }

    public final void set(int n, ASN1Object aSN1Object) {
        if (n >= this.contentIndex || n < 0) {
            throw new IndexOutOfBoundsException("ASN1Structured: get: index " + n + ", size " + this.contentIndex);
        }
        this.content[n] = aSN1Object;
    }

    public final ASN1Object get(int n) {
        if (n >= this.contentIndex || n < 0) {
            throw new IndexOutOfBoundsException("ASN1Structured: set: index " + n + ", size " + this.contentIndex);
        }
        return this.content[n];
    }

    public final int size() {
        return this.contentIndex;
    }

    public String toString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        int n = 0;
        while (n < this.contentIndex) {
            stringBuffer.append(this.content[n]);
            if (n != this.contentIndex - 1) {
                stringBuffer.append(", ");
            }
            ++n;
        }
        stringBuffer.append(" }");
        return super.toString() + stringBuffer.toString();
    }
}

