/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.asn1;

import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Decoder;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Length;
import com.novell.ldap.asn1.ASN1Null;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.ASN1Set;
import com.novell.ldap.asn1.ASN1Tagged;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class LBERDecoder
implements ASN1Decoder {
    private ASN1Identifier asn1ID = new ASN1Identifier();
    private ASN1Length asn1Len = new ASN1Length();

    public ASN1Object decode(byte[] byArray) {
        ASN1Object aSN1Object = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            aSN1Object = this.decode(byteArrayInputStream);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return aSN1Object;
    }

    public ASN1Object decode(InputStream inputStream) throws IOException {
        int[] nArray = new int[1];
        return this.decode(inputStream, nArray);
    }

    public ASN1Object decode(InputStream inputStream, int[] nArray) throws IOException {
        this.asn1ID.reset(inputStream);
        this.asn1Len.reset(inputStream);
        int n = this.asn1Len.getLength();
        nArray[0] = this.asn1ID.getEncodedLength() + this.asn1Len.getEncodedLength() + n;
        if (this.asn1ID.isUniversal()) {
            switch (this.asn1ID.getTag()) {
                case 16: {
                    return new ASN1Sequence(this, inputStream, n);
                }
                case 17: {
                    return new ASN1Set(this, inputStream, n);
                }
                case 1: {
                    return new ASN1Boolean(this, inputStream, n);
                }
                case 2: {
                    return new ASN1Integer(this, inputStream, n);
                }
                case 4: {
                    return new ASN1OctetString(this, inputStream, n);
                }
                case 10: {
                    return new ASN1Enumerated(this, inputStream, n);
                }
                case 5: {
                    return new ASN1Null();
                }
            }
            throw new EOFException("Unknown tag");
        }
        return new ASN1Tagged(this, inputStream, n, (ASN1Identifier)this.asn1ID.clone());
    }

    public final Object decodeBoolean(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray);
        if (n2 != n) {
            throw new EOFException("LBER: BOOLEAN: decode error: EOF");
        }
        return byArray[0] == 0 ? new Boolean(false) : new Boolean(true);
    }

    public final Object decodeNumeric(InputStream inputStream, int n) throws IOException {
        long l = 0L;
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException("LBER: NUMERIC: decode error: EOF");
        }
        if ((n2 & 0x80) != 0) {
            l = -1L;
        }
        l = l << 8 | (long)n2;
        int n3 = 1;
        while (n3 < n) {
            n2 = inputStream.read();
            if (n2 < 0) {
                throw new EOFException("LBER: NUMERIC: decode error: EOF");
            }
            l = l << 8 | (long)n2;
            ++n3;
        }
        return new Long(l);
    }

    public final Object decodeOctetString(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(byArray, n2, n - n2);
            n2 += n3;
        }
        return byArray;
    }

    public final Object decodeCharacterString(InputStream inputStream, int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read();
            if (n3 == -1) {
                throw new EOFException("LBER: CHARACTER STRING: decode error: EOF");
            }
            byArray[n2] = (byte)n3;
            ++n2;
        }
        return new String(byArray, "UTF8");
    }
}

