/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import com.novell.security.sso.SSException;
import com.novell.security.sso.SSPermission;
import com.novell.security.sso.SecretStore;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;

public abstract class Secret
implements Serializable {
    protected long accTime;
    protected long crtTime;
    protected transient StringBuffer erPassword;
    protected SSException getValueException;
    protected String id;
    protected transient boolean isInitialized;
    protected boolean isChanged;
    protected long modTime;
    protected transient byte[] secret;
    protected int ssFlags;
    protected int status;

    protected Secret(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("The identifier may neither be null nor empty");
        }
        this.id = string.intern();
        this.secret = new byte[0];
        this.isChanged = true;
    }

    public final void create() throws SSException {
        this.setCheckingSecretIDCollision(true);
    }

    public final void create(int n) throws SSException {
        this.setCheckingSecretIDCollision(true);
    }

    protected void create0(int n) throws SSException {
    }

    public final void delete() throws SSException {
        this.delete(0);
    }

    public final void delete(int n) throws SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SSPermission("write"));
            }
            catch (SecurityException securityException) {
                securityManager.checkPermission(new SSPermission(this.id, "write"));
            }
        }
        this.delete0(n | this.ssFlags);
    }

    protected abstract void delete0(int var1) throws SSException;

    public boolean equals(Object object) {
        if (object instanceof Secret) {
            return this.id == ((Secret)object).id;
        }
        return false;
    }

    public boolean exists() throws SSException {
        return this.exists(0);
    }

    public boolean exists(int n) throws SSException {
        try {
            this.read(n);
        }
        catch (SSException sSException) {
            int n2 = sSException.getErrorCode();
            switch (n2) {
                case -832: 
                case -810: 
                case -806: {
                    return true;
                }
                case -813: 
                case -812: 
                case -802: {
                    return false;
                }
            }
            throw sSException;
        }
        return true;
    }

    protected void finalize() throws Throwable {
        if (this.erPassword != null && (0x400000 & this.getStatus()) != 0x400000) {
            SecretStore.clearBuffer(this.erPassword);
        }
        if (this.secret != null) {
            Arrays.fill(this.secret, (byte)0);
        }
    }

    public Date getAccessTime() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        return new Date(this.accTime * 1000L);
    }

    public boolean getAutoCreateIDPolicy() {
        return true;
    }

    public Date getCreateTime() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        return new Date(this.crtTime * 1000L);
    }

    public boolean getEnhancedProtectedPolicy() throws SSException {
        return this.isEnhancedProtected();
    }

    public Date getModifyTime() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        return new Date(this.modTime * 1000L);
    }

    public int getStatus() throws SSException {
        if (this.isChanged) {
            this.read();
        }
        return this.status;
    }

    public byte[] getValue() throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        if (this.getValueException != null) {
            throw this.getValueException;
        }
        byte[] byArray = new byte[this.secret.length];
        System.arraycopy(this.secret, 0, byArray, 0, this.secret.length);
        return byArray;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean isCheckingSecretIDCollision() {
        return (0x2000000 & this.ssFlags) == 0x2000000;
    }

    public boolean isEnhancedProtected() throws SSException {
        return (0x40000 & this.getStatus()) == 262144;
    }

    public boolean isEnhancedProtectedWithPassword() throws SSException {
        return (0x200000 & this.getStatus()) == 0x200000 || (0x400000 & this.getStatus()) == 0x400000;
    }

    public final void read() throws SSException {
        this.read(0);
    }

    public final void read(int n) throws SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SSPermission("read"));
            }
            catch (SecurityException securityException) {
                securityManager.checkPermission(new SSPermission(this.id, "read"));
            }
        }
        this.getValueException = null;
        n |= this.ssFlags;
        this.read0(n &= 0xFFFFFFFD);
    }

    protected abstract void read0(int var1) throws SSException;

    public void setAutoCreateIDPolicy(boolean bl) {
    }

    public void setCheckingSecretIDCollision(boolean bl) {
        this.ssFlags = bl ? (this.ssFlags |= 0x2000000) : (this.ssFlags &= 0xFDFFFFFF);
    }

    public void setEnhancedProtected(boolean bl) {
        if (bl) {
            this.ssFlags |= 1;
        } else {
            this.ssFlags &= 0xFFFFFFFE;
            this.ssFlags &= 0xFFFFFFBF;
            this.ssFlags &= 0xFFFFFFDF;
        }
    }

    public void setEnhancedProtectedPolicy(boolean bl) {
        this.setEnhancedProtected(bl);
    }

    public void setEnhancedProtectionPassword(char[] cArray) {
        if (cArray == null) {
            throw new NullPointerException("erPass parameter null");
        }
        StringBuffer stringBuffer = this.erPassword;
        synchronized (stringBuffer) {
            if ((0x20 & this.ssFlags) == 32) {
                this.erPassword = new StringBuffer();
            } else {
                SecretStore.clearBuffer(this.erPassword);
            }
            this.erPassword.append(cArray);
            this.ssFlags |= 1;
            this.ssFlags |= 0x40;
            this.ssFlags &= 0xFFFFFFDF;
        }
    }

    public void setValue(byte[] byArray) throws SSException {
        this.setValue(byArray, 0);
    }

    public synchronized void setValue(byte[] byArray, int n) throws SSException {
        this.write(byArray, n);
        Arrays.fill(this.secret, (byte)0);
        if (byArray != null) {
            byte[] byArray2 = new byte[byArray.length];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            this.secret = byArray2;
        } else {
            this.secret = new byte[0];
        }
    }

    public synchronized boolean sync(Secret secret) throws SSException {
        Secret secret2 = secret;
        synchronized (secret2) {
            if (this.getModifyTime().getTime() != 0L) {
                if (this.getModifyTime().after(secret.getModifyTime())) {
                    secret.setValue(this.secret);
                    boolean bl = true;
                    return bl;
                }
            } else if (this.getCreateTime().after(secret.getCreateTime())) {
                secret.setValue(this.secret);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public String toString() {
        return this.id;
    }

    public void unsetEnhancedProtectionPassword() {
        if ((0x400000 & this.getStatus()) == 0x400000) {
            this.erPassword = new StringBuffer();
        } else {
            SecretStore.clearBuffer(this.erPassword);
        }
        this.ssFlags &= 0xFFFFFFBF;
        this.ssFlags &= 0xFFFFFFDF;
    }

    public void update(Secret secret) throws SSException {
        this.update(secret, 0);
    }

    public void update(Secret secret, int n) throws SSException {
        if (!this.isInitialized) {
            this.read();
        }
        secret.setValue(this.secret, n);
    }

    protected final void write(byte[] byArray, int n) throws SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new SSPermission("write"));
            }
            catch (SecurityException securityException) {
                securityManager.checkPermission(new SSPermission(this.id, "write"));
            }
        }
        n |= this.ssFlags;
        if (this.isCheckingSecretIDCollision()) {
            this.create0(n);
            this.write0(byArray, n);
        } else {
            this.write0(byArray, n | 2);
        }
    }

    protected abstract void write0(byte[] var1, int var2) throws SSException;
}

