/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import com.novell.security.sso.SSException;
import com.novell.security.sso.SSPermission;
import com.novell.security.sso.Secret;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;

public abstract class SecretStore
implements Serializable {
    public static final String CALLER_DN = "com.novell.sso.callerdn";
    public static final String HANDLE = "com.novell.sso.handle";
    public static final String SECRET_STORE = "com.novell.sso.secretstore";
    public static final String SERVER_DN = "com.novell.sso.serverdn";
    public static final String TREE = "com.novell.sso.tree";
    public static final String USER_DN = "com.novell.sso.userdn";
    protected byte clientCryptoStrength;
    protected int clientVersion;
    protected int enumBuffLen;
    protected Hashtable env;
    protected int hiddenCount;
    protected transient char[] hint = new char[0];
    protected transient boolean initialized;
    protected String lastAdminUnlockDn;
    protected long lastAdminUnlockTime;
    protected int lockCount;
    protected transient StringBuffer masterPassword = new StringBuffer();
    protected int secretCount;
    protected byte serverCryptoStrength;
    protected int serverVersion;
    protected int status;

    protected SecretStore() {
    }

    public static final SecretStore getInstance(Hashtable hashtable) throws ClassNotFoundException, IllegalArgumentException, SSException {
        Class[] classArray;
        Object t;
        if (hashtable == null) {
            throw new IllegalArgumentException("Environment properties not specified");
        }
        if (hashtable.containsKey(SECRET_STORE)) {
            if (hashtable.get(SECRET_STORE).toString().equals("com.novell.security.sso.ldap.LdapSecretStore")) {
                hashtable.put(SECRET_STORE, "com.novell.security.sso.ldap.jndi.JNDISecretStore");
                System.out.println("\"com.novell.security.sso.ldap.LdapSecretStore\" has been changed to \"com.novell.security.sso.ldap.jndi.JNDISecretStore\"");
            }
            if (!((t = AccessController.doPrivileged(new PrivilegedAction((String)(classArray = hashtable.get(SECRET_STORE).toString())){
                private final /* synthetic */ String val$storePath;
                {
                    this.val$storePath = string;
                }

                public Object run() {
                    try {
                        return Class.forName(this.val$storePath);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return classNotFoundException;
                    }
                }
            })) instanceof Class)) {
                throw (ClassNotFoundException)t;
            }
        } else {
            throw new IllegalArgumentException("\"com.novell.secretstore\" property not specified");
        }
        Class clazz = (Class)t;
        try {
            classArray = new Class[]{hashtable.getClass()};
            Constructor constructor = clazz.getConstructor(classArray);
            Object[] objectArray = new Object[]{hashtable};
            t = constructor.newInstance(objectArray);
            if (t instanceof SecretStore) {
                return (SecretStore)t;
            }
            throw new IllegalArgumentException("Invalid SecretStore Implementation: specified class not a subclass of com.novell.security.sso.SecretStore");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof SSException) {
                throw (SSException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new IllegalArgumentException(throwable.getMessage());
        }
        catch (Exception exception) {
            if (exception instanceof RuntimeException) {
                throw (RuntimeException)exception;
            }
            throw new IllegalArgumentException("Invalid SecretStore Implementation: " + exception.getMessage());
        }
    }

    public final byte getClientCryptoStrength() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.clientCryptoStrength;
    }

    public final int getClientVersion() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.clientVersion;
    }

    public final int getEnumBuffLen() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.enumBuffLen;
    }

    public final Object getEnvironmentProperty(String string) {
        return this.env.get(string);
    }

    public final char[] getHint() throws SSException {
        SecurityManager securityManager;
        if (!this.initialized) {
            this.getServiceInfo();
        }
        if ((securityManager = System.getSecurityManager()) != null) {
            securityManager.checkPermission(new SSPermission("admin"));
        }
        char[] cArray = new char[this.hint.length];
        System.arraycopy(this.hint, 0, cArray, 0, this.hint.length);
        return cArray;
    }

    public final String getLastAdminUnlockDn() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.lastAdminUnlockDn;
    }

    public final Date getLastAdminUnlockTime() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return new Date(this.lastAdminUnlockTime * 1000L);
    }

    public final void setMasterPassword(char[] cArray) {
        SecretStore.clearBuffer(this.masterPassword);
        this.masterPassword.append(cArray);
    }

    public final int getNumLockedSecrets() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.lockCount;
    }

    public final int getNumSecrets() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.secretCount;
    }

    public final Secret getSecret(String string) {
        return this.getSecret(string, false);
    }

    public Secret getSecret(String string, boolean bl) {
        return this.getSecret0(string, bl);
    }

    protected abstract Secret getSecret0(String var1, boolean var2);

    public Secret[] getSecrets(int n, String string, int n2, boolean bl) throws SSException {
        StringTokenizer stringTokenizer = this.enumerateSecrets(n, string, n2);
        Secret[] secretArray = new Secret[stringTokenizer.countTokens()];
        int n3 = 0;
        while (n3 < secretArray.length) {
            secretArray[n3] = this.getSecret(stringTokenizer.nextToken(), bl);
            ++n3;
        }
        return secretArray;
    }

    public final byte getServerCryptoStrength() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.serverCryptoStrength;
    }

    public final int getServerVersion() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.serverVersion;
    }

    public final void getServiceInfo() throws SSException {
        this.getServiceInfo(0);
    }

    public final void getServiceInfo(int n) throws SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSPermission("read"));
        }
        this.getServiceInfo0(n);
    }

    public final int getStatus() throws SSException {
        if (!this.initialized) {
            this.getServiceInfo();
        }
        return this.status;
    }

    public final void commitMasterPasswordChange() throws SSException {
        this.commitMasterPasswordChange(0, new char[0]);
    }

    public final void commitMasterPasswordChange(int n) throws SSException {
        this.commitMasterPasswordChange(n, new char[0]);
    }

    public final void commitMasterPasswordChange(int n, char[] cArray) throws SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSPermission("admin"));
        }
        this.commitMasterPasswordChange0(n, cArray);
    }

    public final StringTokenizer enumerateSecrets() throws SSException {
        return this.enumerateSecrets(0, "", 131072);
    }

    public final StringTokenizer enumerateSecrets(int n, String string) throws SSException {
        return this.enumerateSecrets(n, string, 131072);
    }

    public final StringTokenizer enumerateSecrets(int n, String string, int n2) throws SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSPermission("read"));
        }
        return this.enumerateSecrets0(n, string, n2);
    }

    public final void removeSecretStore() throws SSException {
        this.removeSecretStore(0);
    }

    public final void removeSecretStore(int n) throws SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSPermission("admin"));
        }
        this.removeSecretStore0(n);
    }

    public final int sync(SecretStore secretStore) throws SSException {
        return this.sync(secretStore, 0, "", 131072);
    }

    public int sync(SecretStore secretStore, int n, String string, int n2) throws SSException {
        int n3 = 0;
        SSException sSException = null;
        StringTokenizer stringTokenizer = this.enumerateSecrets(n, string, n2);
        StringTokenizer stringTokenizer2 = secretStore.enumerateSecrets(n, string, n2);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer2.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer2.nextToken());
        }
        String string2 = stringBuffer.toString();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            Secret secret = this.getSecret(string3);
            Secret secret2 = secretStore.getSecret(string3);
            try {
                if (string2.indexOf(string3) != -1) {
                    if (!secret.sync(secret2)) continue;
                    ++n3;
                    continue;
                }
                secret.update(secret2);
                ++n3;
            }
            catch (SSException sSException2) {
                if (sSException2.hasRoot()) {
                    throw new SSException(sSException2.getRoot(), secret.id);
                }
                sSException = new SSException(SSException.generateMessage(sSException2.getErrorCode()) + " " + secret.id, sSException2.getErrorCode());
            }
        }
        if (sSException != null) {
            throw sSException;
        }
        return n3;
    }

    public String toString() {
        return this.env.get(USER_DN) + " " + this.getClass().getName();
    }

    public final void unlockSecretStore() throws IllegalArgumentException, SSException {
        this.unlockSecretStore(0);
    }

    public final void unlockSecretStore(int n) throws IllegalArgumentException, SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSPermission("admin"));
        }
        this.unlockSecretStore0(n);
    }

    public final void unlockSecretStore(int n, char[] cArray) throws SSException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new SSPermission("admin"));
        }
        this.unlockSecretStore0(n, cArray);
    }

    public final void unsetMasterPassword() {
        SecretStore.clearBuffer(this.masterPassword);
    }

    public final void update(SecretStore secretStore) throws SSException {
        this.update(secretStore, 0, "", 131072);
    }

    public void update(SecretStore secretStore, int n, String string, int n2) throws SSException {
        Secret[] secretArray = this.getSecrets(n, string, n2, false);
        SSException sSException = null;
        int n3 = 0;
        while (n3 < secretArray.length) {
            try {
                Secret secret = secretStore.getSecret(secretArray[n3].id);
                secretArray[n3].update(secret);
            }
            catch (SSException sSException2) {
                if (sSException2.hasRoot()) {
                    throw new SSException(sSException2.getRoot(), secretArray[n3].id);
                }
                sSException = new SSException(SSException.generateMessage(sSException2.getErrorCode()) + " " + secretArray[n3].id, sSException2.getErrorCode());
            }
            ++n3;
        }
        if (sSException != null) {
            throw sSException;
        }
    }

    protected abstract void getServiceInfo0(int var1) throws SSException;

    protected abstract void commitMasterPasswordChange0(int var1, char[] var2) throws SSException;

    protected abstract StringTokenizer enumerateSecrets0(int var1, String var2, int var3) throws SSException;

    public boolean equals(Object object) {
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    protected abstract void removeSecretStore0(int var1) throws SSException;

    protected abstract void unlockSecretStore0(int var1) throws IllegalArgumentException, SSException;

    protected abstract void unlockSecretStore0(int var1, char[] var2) throws SSException;

    protected static final void clearBuffer(StringBuffer stringBuffer) {
        if (stringBuffer != null) {
            StringBuffer stringBuffer2 = stringBuffer;
            synchronized (stringBuffer2) {
                int n = 0;
                while (n < stringBuffer.length()) {
                    stringBuffer.setCharAt(n, '\u0000');
                    ++n;
                }
                stringBuffer.setLength(0);
            }
        }
    }

    protected void finalize() throws Throwable {
        SecretStore.clearBuffer(this.masterPassword);
        Arrays.fill(this.hint, '\u0000');
    }
}

