/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso;

import java.io.Serializable;

public class SharedEntry
implements Cloneable,
Comparable,
Serializable {
    public static final char CREDENTIAL_DELIMITER = ':';
    public static final char NORMAL_DELIMITER = '=';
    private String entryStr;
    private boolean isCredSet;
    private String key;
    private String value;

    public SharedEntry(String string, String string2) {
        if (string == null || string.length() == 0 || string2 == null) {
            throw new IllegalArgumentException("Invalid SharedEntry data");
        }
        this.key = string;
        this.value = string2;
        this.isCredSet = string.equals("SS_CredSet");
    }

    public boolean isCredSet() {
        return this.isCredSet;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public int compareTo(Object object) {
        if (object instanceof SharedEntry && !this.isCredSet) {
            return this.key.toUpperCase().compareTo(((SharedEntry)object).key.toUpperCase());
        }
        return this.toString().toUpperCase().compareTo(object.toString().toUpperCase());
    }

    public boolean equals(Object object) {
        if (object instanceof SharedEntry) {
            if (this.isCredSet) {
                return this.toString().equalsIgnoreCase(object.toString());
            }
            return this.key.equalsIgnoreCase(((SharedEntry)object).key);
        }
        return false;
    }

    public static String escapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 6);
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            switch (c) {
                case '\\': {
                    stringBuffer.append("\\\\");
                    break;
                }
                case ':': {
                    stringBuffer.append("\\:");
                    break;
                }
                case '=': {
                    stringBuffer.append("\\=");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.isCredSet) {
            return this.toString().toUpperCase().hashCode();
        }
        return this.key.toUpperCase().hashCode();
    }

    public static SharedEntry parseEntry(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new IllegalArgumentException("String is null");
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String string2 = "";
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                if (n + 1 < string.length() && ((c = string.charAt(n + 1)) == '\\' || c == '=' || c == ':')) {
                    stringBuffer.append(c);
                    ++n;
                }
            } else {
                if (c == '=' || c == ':') {
                    if (stringBuffer.toString().equals("SS_CredSet") ? c != ':' : c != '=') {
                        throw new IllegalArgumentException("Invalid delimiter '" + c + '\'');
                    }
                    if (n + 1 < string.length()) {
                        string2 = string.substring(n + 1, string.length());
                    }
                    bl = true;
                    break;
                }
                stringBuffer.append(c);
            }
            ++n;
        }
        if (!bl) {
            throw new IllegalArgumentException("No valid delimiter in String");
        }
        String string3 = stringBuffer.toString();
        if (string3.length() > 0) {
            string2 = string2.length() > 0 ? SharedEntry.unescapeString(string2) : string2;
            return new SharedEntry(string3, string2);
        }
        throw new IllegalArgumentException("No valid key in String");
    }

    public void setValue(String string) {
        String string2 = this.key;
        synchronized (string2) {
            if (string == null) {
                throw new IllegalArgumentException("Invalid SharedEntry value");
            }
            this.value = string;
            this.entryStr = null;
        }
    }

    public String toString() {
        String string = this.key;
        synchronized (string) {
            if (this.entryStr == null) {
                StringBuffer stringBuffer = new StringBuffer(this.key.length() + this.value.length() + 1);
                String string2 = this.isCredSet ? this.key : SharedEntry.escapeString(this.key);
                char c = this.isCredSet ? (char)':' : '=';
                String string3 = SharedEntry.escapeString(this.value);
                stringBuffer.append(string2).append(c).append(string3);
                this.entryStr = stringBuffer.toString();
            }
        }
        return this.entryStr;
    }

    public static String unescapeString(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == '\\') {
                if (n + 1 < string.length() && (c = string.charAt(n + 1)) == '\\') {
                    stringBuffer.append(c);
                    ++n;
                }
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }
}

