/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.ldap.ber.SSResponse;
import java.io.IOException;
import java.util.Arrays;

public class EnumResponse
extends SSResponse {
    private int idCount;
    private char[] secretIDs;

    public EnumResponse(byte[] byArray) {
        super("2.16.840.1.113719.1.148.100.14", byArray);
    }

    public int getCount() {
        return this.idCount;
    }

    public char[] getEnumeration() {
        char[] cArray = new char[this.secretIDs.length];
        System.arraycopy(this.secretIDs, 0, cArray, 0, this.secretIDs.length);
        return cArray;
    }

    protected void finalize() throws Throwable {
        if (this.secretIDs != null) {
            Arrays.fill(this.secretIDs, ' ');
        }
        super.finalize();
    }

    protected void parsePacket() throws IOException {
        ASN1Object aSN1Object;
        super.parsePacket();
        int n = this.asn1_seq.size();
        if (this.packetIdx < n) {
            aSN1Object = (ASN1Integer)this.asn1_seq.get(this.packetIdx++);
            this.idCount = aSN1Object.intValue();
        }
        if (this.packetIdx < n) {
            aSN1Object = (ASN1OctetString)this.asn1_seq.get(this.packetIdx++);
            this.secretIDs = SSResponse.formatString((ASN1OctetString)aSN1Object);
        }
    }
}

