/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.ReadResponse;
import com.novell.security.sso.ldap.ber.SSRequest;
import java.io.IOException;
import java.util.Arrays;
import sun.io.CharToByteConverter;

public class ReadRequest
extends SSRequest {
    private transient char[] enhancePass;
    private String secretIdentifier;

    public ReadRequest(int n, String string, String string2, char[] cArray) {
        super("2.16.840.1.113719.1.148.100.3", n, string, false);
        this.secretIdentifier = string2;
        this.enhancePass = cArray;
        this.constructPacket();
    }

    public Object createExtendedResponse(String string, byte[] byArray) {
        return new ReadResponse(byArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void constructPacket() throws SSException {
        byte[] byArray;
        super.constructPacket(false);
        ASN1OctetString aSN1OctetString = null;
        try {
            try {
                this.secretIdentifier = this.secretIdentifier + '\u0000';
                ASN1OctetString aSN1OctetString2 = new ASN1OctetString(this.secretIdentifier.getBytes("UTF-8"));
                this.asn1_seq.add(aSN1OctetString2);
                if (this.enhancePass.length > 0) {
                    CharToByteConverter charToByteConverter = CharToByteConverter.getConverter((String)"UTF-8");
                    char[] cArray = new char[this.enhancePass.length + 1];
                    System.arraycopy(this.enhancePass, 0, cArray, 0, this.enhancePass.length);
                    cArray[this.enhancePass.length] = '\u0000';
                    byte[] byArray2 = charToByteConverter.convertAll(cArray);
                    aSN1OctetString = new ASN1OctetString(byArray2);
                    this.asn1_seq.add(aSN1OctetString);
                }
                this.asn1_seq.encode(this.enc, this.out);
                if (this.packet != null) {
                    Arrays.fill(this.packet, (byte)0);
                }
                this.packet = this.out.toByteArray();
            }
            catch (IOException iOException) {
                throw new SSException(iOException, "Encoding Error:");
            }
            Object var7_7 = null;
            if (aSN1OctetString == null) return;
            byArray = aSN1OctetString.byteValue();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (aSN1OctetString == null) throw throwable;
            byte[] byArray3 = aSN1OctetString.byteValue();
            Arrays.fill(byArray3, (byte)0);
            throw throwable;
        }
        Arrays.fill(byArray, (byte)0);
    }
}

