/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ldap.ber;

import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1OctetString;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.asn1.LBERDecoder;
import com.novell.security.sso.SSException;
import com.novell.security.sso.ldap.ber.SSExtension;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import sun.io.ByteToCharConverter;

public class SSResponse
extends SSExtension {
    protected transient ASN1Sequence asn1_seq;
    protected transient LBERDecoder dec;
    protected transient int error;
    protected transient ByteArrayInputStream in;
    protected int packetIdx;

    public SSResponse(String string, byte[] byArray) throws SSException {
        super(string);
        this.in = new ByteArrayInputStream(byArray);
        this.asn1_seq = new ASN1Sequence();
        this.dec = new LBERDecoder();
        try {
            this.asn1_seq = (ASN1Sequence)this.dec.decode(this.in);
            this.parsePacket();
        }
        catch (Throwable throwable) {
            System.out.println("response: " + string + " packet: " + this.asn1_seq.toString());
            throwable.printStackTrace();
            throw new SSException(throwable, "Decoding Error:");
        }
    }

    public int getErrorCode() {
        return this.error;
    }

    protected static char[] formatString(ASN1OctetString aSN1OctetString) throws IOException {
        ByteToCharConverter byteToCharConverter = ByteToCharConverter.getConverter((String)"UTF-8");
        char[] cArray = byteToCharConverter.convertAll(aSN1OctetString.byteValue());
        if (cArray != null) {
            int n = 0;
            while (n < cArray.length) {
                if (cArray[n] == '\u0000') {
                    char[] cArray2 = new char[n];
                    System.arraycopy(cArray, 0, cArray2, 0, n);
                    return cArray2;
                }
                ++n;
            }
        }
        return cArray == null ? cArray : new char[]{};
    }

    protected void parsePacket() throws IOException {
        ASN1Object aSN1Object;
        int n = this.asn1_seq.size();
        if (this.packetIdx < n && this.asn1_seq.get(this.packetIdx) instanceof ASN1Integer && (aSN1Object = this.asn1_seq.get(this.packetIdx)) instanceof ASN1Integer) {
            this.error = ((ASN1Integer)aSN1Object).intValue();
            ++this.packetIdx;
        }
    }
}

