/*
 * Decompiled with CFR 0.152.
 */
package com.novell.security.sso.ncp;

import com.novell.security.sso.SSException;
import com.novell.security.sso.Secret;
import com.novell.security.sso.ncp.SSOWrap;
import java.util.Arrays;

public final class NCPSecret
extends Secret {
    private String obj;
    private String tree;

    NCPSecret(String string) {
        super(string);
        this.erPassword = new StringBuffer();
    }

    NCPSecret(String string, String string2, String string3) {
        super(string);
        this.obj = string2;
        this.tree = string3;
        this.erPassword = new StringBuffer();
    }

    NCPSecret(String string, String string2, String string3, StringBuffer stringBuffer) {
        super(string);
        this.obj = string2;
        this.tree = string3;
        this.erPassword = stringBuffer;
        this.ssFlags |= 1;
        this.ssFlags |= 0x20;
    }

    NCPSecret(String string, StringBuffer stringBuffer) {
        super(string);
        this.erPassword = stringBuffer;
        this.ssFlags |= 1;
        this.ssFlags |= 0x20;
    }

    protected synchronized void create0(int n) throws SSException {
        int n2 = SSOWrap.addSecretID(this.id, n, this.obj, this.tree);
        if (n2 != 0) {
            throw new SSException(n2);
        }
        this.isChanged = true;
    }

    protected synchronized void delete0(int n) throws SSException {
        int n2 = SSOWrap.removeSecretID(this.id, n, this.obj, this.tree);
        if (n2 != 0) {
            throw new SSException(n2);
        }
    }

    protected synchronized void read0(int n) throws SSException {
        Object[] objectArray;
        this.isInitialized = true;
        String string = null;
        if (this.erPassword.length() > 0) {
            objectArray = new char[this.erPassword.length()];
            this.erPassword.getChars(0, this.erPassword.length(), (char[])objectArray, 0);
            string = new String((char[])objectArray);
            Arrays.fill(objectArray, '\u0000');
        } else {
            n &= 0xFFFFFFBF;
            n &= 0xFFFFFFDF;
        }
        objectArray = new int[5];
        byte[] byArray = SSOWrap.readSecret(this.id, n, string, this.obj, this.tree, objectArray);
        int n2 = 0;
        this.status = objectArray[n2++];
        this.crtTime = objectArray[n2++];
        this.accTime = objectArray[n2++];
        this.modTime = objectArray[n2++];
        char c = objectArray[n2];
        this.isChanged = false;
        if (c != '\u0000') {
            if (c == '\ufffffcdc' || c == '\ufffffcc0' || c == '\ufffffcda' || c == '\ufffffcd5') {
                this.getValueException = new SSException(c);
            } else {
                throw new SSException(c);
            }
        }
        if (byArray != null && byArray.length > 0) {
            Arrays.fill(this.secret, (byte)0);
            this.secret = byArray;
        }
    }

    protected synchronized void write0(byte[] byArray, int n) throws SSException {
        int n2;
        Object[] objectArray;
        String string = null;
        if (this.erPassword.length() > 0) {
            objectArray = new char[this.erPassword.length()];
            this.erPassword.getChars(0, this.erPassword.length(), (char[])objectArray, 0);
            string = new String((char[])objectArray);
            Arrays.fill(objectArray, '\u0000');
        } else {
            n &= 0xFFFFFFBF;
            n &= 0xFFFFFFDF;
        }
        objectArray = byArray;
        synchronized (objectArray) {
            n2 = SSOWrap.writeSecret(this.id, n, byArray, string, this.obj, this.tree);
        }
        if (n2 != 0) {
            throw new SSException(n2);
        }
        this.isChanged = true;
    }
}

