/*
 * Decompiled with CFR 0.152.
 */
package com.novell.NvdsLdapExtensions;

import java.util.Vector;
import org.jdom.Element;
import org.jdom.Namespace;

public class EnforcementData {
    private Element dataElement;
    private Namespace pMgrNamespace = Namespace.getNamespace((String)"http://www.novell.com/delphi/policymgr");
    private String m_entry;
    private String m_attribute;
    private int m_permissions;

    public EnforcementData(Element enforcementElement) {
        this.dataElement = enforcementElement.getChild("ACL", this.pMgrNamespace);
    }

    public boolean getData() {
        boolean flag = false;
        if (this.dataElement != null) {
            Element attributeElement;
            flag = true;
            Element entryElement = this.dataElement.getChild("Entry", this.pMgrNamespace);
            if (entryElement != null && entryElement.getTextTrim().length() > 0) {
                this.m_entry = entryElement.getTextTrim();
            }
            this.m_attribute = (attributeElement = this.dataElement.getChild("Attribute", this.pMgrNamespace)) != null && attributeElement.getTextTrim().length() > 0 ? attributeElement.getTextTrim() : "[Entry Rights]";
            Element permissionsElement = this.dataElement.getChild("Permissions", this.pMgrNamespace);
            if (permissionsElement != null && permissionsElement.getTextTrim().length() > 0) {
                this.m_permissions = new Integer(permissionsElement.getTextTrim());
            }
        }
        return flag;
    }

    public String getEntry() {
        return this.m_entry;
    }

    public String getAttribute() {
        return this.m_attribute;
    }

    public int getPermissions() {
        return this.m_permissions;
    }

    public String[] getPermissionsStrings() {
        Vector<String> permissionStrings = new Vector<String>();
        if (this.m_attribute.equalsIgnoreCase("[Entry Rights]")) {
            if ((this.m_permissions & 1) == 1) {
                permissionStrings.add("Browse");
            }
            if ((this.m_permissions & 2) == 2) {
                permissionStrings.add("Create");
            }
            if ((this.m_permissions & 4) == 4) {
                permissionStrings.add("Delete");
            }
            if ((this.m_permissions & 8) == 8) {
                permissionStrings.add("Rename");
            }
            if ((this.m_permissions & 0x10) == 16) {
                permissionStrings.add("Supervisor");
            }
            if ((this.m_permissions & 0x20) == 32) {
                permissionStrings.add("AddForwardReference");
            }
        } else {
            if ((this.m_permissions & 1) == 1) {
                permissionStrings.add("Compare");
            }
            if ((this.m_permissions & 2) == 2) {
                permissionStrings.add("Read");
            }
            if ((this.m_permissions & 4) == 4) {
                permissionStrings.add("Modify");
            }
            if ((this.m_permissions & 8) == 8) {
                permissionStrings.add("Delete");
            }
            if ((this.m_permissions & 0x10) == 16) {
                permissionStrings.add("Supervisor");
            }
            if ((this.m_permissions & 0x20) == 16) {
                permissionStrings.add("Self");
            }
        }
        if (permissionStrings.size() == 0) {
            return null;
        }
        Object[] strings = new String[permissionStrings.size()];
        permissionStrings.copyInto(strings);
        return strings;
    }
}

