/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;

public class ASCIIEncoder
extends CharEncoder {
    public static final String NAME = "US-ASCII";
    public static final String NAME_SECONDARY = "ASCII";

    public int encodeChars(char[] chars, int off, int len, byte[] buffer, int outputIndex) throws CharEncodingException, EncodingBufferFullException {
        int outOff = outputIndex;
        int max = off + len;
        for (int i = off; i < max; ++i) {
            char c = chars[i];
            if ('\u0000' <= c && c <= '\u007f') {
                if (outOff >= buffer.length) {
                    throw new EncodingBufferFullException(outOff, i);
                }
            } else {
                if ('\ud800' <= c && c < '\udc00' && i + 1 < max) {
                    char trail = chars[++i];
                    int c32 = (c - 55296 << 10) + (trail - 56320) + 65536;
                    throw new CharEncodingException(c32, i, outOff);
                }
                throw new CharEncodingException(c & 0xFFFF, i, outOff);
            }
            buffer[outOff++] = (byte)c;
        }
        return outOff - outputIndex;
    }

    public int encodeChar(int c, byte[] buffer, int off) throws CharEncodingException, EncodingBufferFullException {
        if (c < 127) {
            if (off < buffer.length) {
                buffer[off] = (byte)c;
                return 1;
            }
            throw new EncodingBufferFullException(off, 0);
        }
        throw new CharEncodingException(c, 0, off);
    }

    public String getEncoding() {
        return NAME;
    }
}

