/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.io.StringReader;

public class Base64InputStream
extends InputStream {
    private static byte[] codes;
    int iBufferSize = 3;
    byte[] buf = new byte[this.iBufferSize];
    int buffered = 0;
    char[] ebuf = new char[4 * this.iBufferSize / 3];
    Reader inRdr;

    public Base64InputStream(InputStream in) {
        this.inRdr = new BufferedReader(new WSStripReader(new InputStreamReader(in)));
    }

    public Base64InputStream(String str) {
        this.inRdr = new WSStripReader(new StringReader(str));
    }

    public synchronized int read() throws IOException {
        try {
            int b = -1;
            if (this.buffered == 0) {
                this.fill_buffer();
            }
            b = this.buf[this.iBufferSize - this.buffered--] & 0xFF;
            return b;
        }
        catch (EOFException eofe) {
            return -1;
        }
    }

    public synchronized int peek() throws IOException {
        try {
            int b = -1;
            int tmpBuffered = this.buffered;
            if (tmpBuffered == 0) {
                this.fill_buffer();
            }
            b = this.buf[this.iBufferSize - tmpBuffered--];
            return b;
        }
        catch (EOFException eofe) {
            return -1;
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        for (int i = off; i < off + len; ++i) {
            int c = this.read();
            if (c == -1) {
                if (i - off > 0) {
                    return i - off;
                }
                return -1;
            }
            b[i] = (byte)c;
        }
        return len;
    }

    public long skip(long n) throws IOException {
        int i = 1;
        while ((long)i <= n) {
            int c = this.read();
            if (c == -1) {
                return i - 1;
            }
            ++i;
        }
        return n;
    }

    protected void fill_buffer() throws IOException {
        if (this.buffered != 0) {
            return;
        }
        int l = this.inRdr.read(this.ebuf, 0, this.ebuf.length);
        if (l == -1) {
            throw new EOFException();
        }
        this.buf = Base64InputStream.decode(this.ebuf, 0, l);
        this.iBufferSize = this.buffered = this.buf.length;
    }

    public static byte[] decode(String strData) throws IOException {
        int len = strData.length();
        char[] data = new char[len];
        strData.getChars(0, len, data, 0);
        return Base64InputStream.decode(data);
    }

    public static byte[] decode(char[] data) throws IOException {
        return Base64InputStream.decode(data, 0, data.length);
    }

    public static byte[] decode(char[] data, int off, int len) throws IOException {
        int iTempLen = (len + 3) / 4 * 3;
        if (len > 0 && data[off + len - 1] == '=') {
            --iTempLen;
        }
        if (len > 1 && data[off + len - 2] == '=') {
            --iTempLen;
        }
        byte[] out = new byte[iTempLen];
        int shift = 0;
        int accum = 0;
        int index = 0;
        int wspc = 0;
        for (int ix = off; ix < off + len; ++ix) {
            byte value = codes[data[ix] & 0xFF];
            if (value >= 0) {
                accum <<= 6;
                accum |= value;
                if ((shift += 6) < 8) continue;
                out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
                continue;
            }
            if (value != -2) continue;
            ++wspc;
        }
        if (index != out.length) {
            if (wspc != 0) {
                iTempLen = (len - wspc + 3) / 4 * 3;
                boolean foundEquals = false;
                for (int i = off + len - 1; i >= off; --i) {
                    char c = data[i];
                    if (c == ' ' || c == '\t' || c == '\r' || c == '\n' || c == '\f') continue;
                    if (c != '=') break;
                    --iTempLen;
                    if (foundEquals) break;
                    foundEquals = true;
                }
                if (index != iTempLen) {
                    throw new StreamCorruptedException("Miscalculated data length! index = " + index + ", out.length = " + out.length);
                }
                byte[] tmpout = new byte[iTempLen];
                System.arraycopy(out, 0, tmpout, 0, iTempLen);
                out = tmpout;
            } else {
                throw new StreamCorruptedException("Miscalculated data length! index = " + index + ", out.length = " + out.length);
            }
        }
        return out;
    }

    static {
        int i;
        codes = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64InputStream.codes[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64InputStream.codes[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64InputStream.codes[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64InputStream.codes[i] = (byte)(52 + i - 48);
        }
        Base64InputStream.codes[43] = 62;
        Base64InputStream.codes[47] = 63;
        Base64InputStream.codes[9] = -2;
        Base64InputStream.codes[12] = -2;
        Base64InputStream.codes[10] = -2;
        Base64InputStream.codes[13] = -2;
        Base64InputStream.codes[32] = -2;
    }

    private class WSStripReader
    extends FilterReader {
        public WSStripReader(Reader rdr) {
            super(rdr);
        }

        public int read() throws IOException {
            int c;
            while ((c = this.in.read()) == 32 || c == 9 || c == 13 || c == 10 || c == 12) {
            }
            return c;
        }

        public int read(char[] cbuf, int off, int len) throws IOException {
            for (int i = off; i < off + len; ++i) {
                int c = this.read();
                if (c == -1) {
                    if (i == off) {
                        return -1;
                    }
                    return i - off;
                }
                cbuf[i] = (char)c;
            }
            return len;
        }
    }
}

