/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.Writer;

public class Base64OutputStream
extends OutputStream {
    private final int iBufferSize = 3;
    byte[] buf = new byte[3];
    int buffered = 0;
    int chunksdone = 0;
    boolean finished = false;
    Writer out;
    private static char[] alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
    private static int WRAP_LINE_LENGTH = 64;

    public Base64OutputStream(Writer out) {
        this.out = out;
    }

    public synchronized void write(int b) throws IOException {
        this.buf[this.buffered++] = (byte)b;
        if (this.buffered == this.buf.length) {
            this.empty_buffer();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    public void write(InputStream is) throws IOException {
        if (this.buffered != 0) {
            int iEOF = 0;
            while (this.buffered != this.buf.length) {
                iEOF = is.read();
                if (iEOF != -1) {
                    this.write(iEOF);
                    continue;
                }
                return;
            }
        }
        while ((this.buffered = is.read(this.buf)) == this.buf.length) {
            this.empty_buffer();
        }
    }

    public void flush() throws IOException {
        this.empty_buffer();
        this.out.flush();
    }

    public synchronized void close() throws IOException {
        this.flush();
        this.out.close();
        super.close();
    }

    protected void empty_buffer() throws IOException {
        if (this.buffered == 0) {
            return;
        }
        if (this.finished) {
            throw new StreamCorruptedException();
        }
        this.out.write(Base64OutputStream.encode(this.buf, 0, this.buffered, false));
        ++this.chunksdone;
        this.buffered = 0;
        if (this.chunksdone / 3 >= 6 || this.finished) {
            this.out.write(10);
            this.chunksdone = 0;
        }
    }

    public static char[] encode(byte[] data) {
        return Base64OutputStream.encode(data, 0, data == null ? 0 : data.length, false);
    }

    public static char[] encode(byte[] data, boolean wrap) {
        return Base64OutputStream.encode(data, 0, data == null ? 0 : data.length, wrap);
    }

    public static char[] encode(byte[] data, int off, int len) {
        return Base64OutputStream.encode(data, off, len, false);
    }

    public static char[] encode(byte[] data, int off, int len, boolean wrap) {
        int outputSize = (len + 2) / 3 * 4;
        if (wrap) {
            outputSize += outputSize / WRAP_LINE_LENGTH;
        }
        char[] out = new char[outputSize];
        int i = off;
        int index = 0;
        int charsOnLine = 0;
        while (i < len + off) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < len + off) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < len + off) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = alphabet[quad ? val & 0x3F : 64];
            out[index + 2] = alphabet[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = alphabet[(val >>= 6) & 0x3F];
            out[index + 0] = alphabet[(val >>= 6) & 0x3F];
            if (wrap && (charsOnLine += 4) == WRAP_LINE_LENGTH) {
                out[index + 4] = 10;
                ++index;
                charsOnLine = 0;
            }
            i += 3;
            index += 4;
        }
        return out;
    }
}

