/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncodingException;
import com.novell.io.EncoderWrapper;
import com.novell.io.EncodingBufferFullException;
import com.novell.io.ISO885914Encoder;
import com.novell.io.ISO885915Encoder;
import com.novell.io.ISO88592Encoder;
import com.novell.io.ISO88593Encoder;
import com.novell.io.ISO88594Encoder;
import com.novell.io.ISO88595Encoder;
import com.novell.io.ISO88596Encoder;
import com.novell.io.ISO88597Encoder;
import com.novell.io.ISO88598Encoder;
import com.novell.io.ISO88599Encoder;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public abstract class CharEncoder {
    private static Map encoderMap = new HashMap();

    public static CharEncoder getEncoder(String encoding) throws UnsupportedEncodingException {
        block5: {
            String normalizedName = encoding.toUpperCase();
            Class encoderClass = (Class)encoderMap.get(normalizedName);
            if (encoderClass != null) {
                try {
                    return (CharEncoder)encoderClass.newInstance();
                }
                catch (InstantiationException e) {
                    break block5;
                }
                catch (IllegalAccessException e) {
                    break block5;
                }
            }
            Charset charset = Charset.forName(encoding);
            if (charset != null && charset.canEncode()) {
                return new EncoderWrapper(charset.newEncoder());
            }
        }
        throw new UnsupportedEncodingException(encoding);
    }

    public int encodeChars(char[] chars, int off, int len, byte[] buffer, int outputIndex) throws CharEncodingException, EncodingBufferFullException {
        int i;
        int c = 0;
        int outOff = outputIndex;
        int max = off + len;
        try {
            int size;
            for (i = off; i < max; i += size) {
                size = 1;
                c = chars[i] & 0xFFFF;
                if (55296 <= c && c < 56320 && i + 1 < max) {
                    char trail = chars[++i];
                    c = (c - 55296 << 10) + (trail - 56320) + 65536;
                    size = 2;
                }
                outOff += this.encodeChar(c, buffer, outOff);
            }
        }
        catch (CharEncodingException e) {
            throw new CharEncodingException(c, i, outOff);
        }
        catch (EncodingBufferFullException e) {
            throw new EncodingBufferFullException(outOff, i);
        }
        return outOff - outputIndex;
    }

    public void reset() {
    }

    public abstract int encodeChar(int var1, byte[] var2, int var3) throws CharEncodingException, EncodingBufferFullException;

    public abstract String getEncoding();

    protected static void registerEncoder(String encoding, Class encoderClass) {
        String normalizedName = encoding.toUpperCase();
        encoderMap.put(normalizedName, encoderClass);
    }

    protected static Class doGetClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        CharEncoder.registerEncoder("US-ASCII", CharEncoder.doGetClass("com.novell.io.ASCIIEncoder"));
        CharEncoder.registerEncoder("ASCII", CharEncoder.doGetClass("com.novell.io.ASCIIEncoder"));
        CharEncoder.registerEncoder("ISO-8859-1", CharEncoder.doGetClass("com.novell.io.ISO88591Encoder"));
        CharEncoder.registerEncoder(ISO88592Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88592Encoder"));
        CharEncoder.registerEncoder(ISO88593Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88593Encoder"));
        CharEncoder.registerEncoder(ISO88594Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88594Encoder"));
        CharEncoder.registerEncoder(ISO88595Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88595Encoder"));
        CharEncoder.registerEncoder(ISO88596Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88596Encoder"));
        CharEncoder.registerEncoder(ISO88597Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88597Encoder"));
        CharEncoder.registerEncoder(ISO88598Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88598Encoder"));
        CharEncoder.registerEncoder(ISO88599Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO88599Encoder"));
        CharEncoder.registerEncoder(ISO885914Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO885914Encoder"));
        CharEncoder.registerEncoder(ISO885915Encoder.NAME, CharEncoder.doGetClass("com.novell.io.ISO885915Encoder"));
        CharEncoder.registerEncoder("UTF-8", CharEncoder.doGetClass("com.novell.io.UTF8Encoder"));
        CharEncoder.registerEncoder("UTF-16", CharEncoder.doGetClass("com.novell.io.UTF16Encoder"));
    }
}

