/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

class EncoderWrapper
extends CharEncoder {
    protected CharsetEncoder encoder;

    EncoderWrapper(CharsetEncoder encoder) {
        this.encoder = encoder;
        this.encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
    }

    private void handleResult(CharBuffer in, ByteBuffer out, CoderResult result) throws CharEncodingException, EncodingBufferFullException {
        if (result.isOverflow()) {
            throw new EncodingBufferFullException(out.position(), in.position());
        }
        if (result.isUnmappable()) {
            int offset = in.position();
            int c = in.get(offset);
            if (55296 <= c && c < 56320 && in.limit() - offset >= 1) {
                char trail = in.get(offset + 1);
                c = (c - 55296 << 10) + (trail - 56320) + 65536;
            }
            throw new CharEncodingException(c, offset, out.position());
        }
    }

    public int encodeChars(char[] chars, int off, int len, byte[] buffer, int outputIndex) throws CharEncodingException, EncodingBufferFullException {
        CharBuffer in = CharBuffer.wrap(chars, off, len);
        ByteBuffer out = ByteBuffer.wrap(buffer, outputIndex, buffer.length - outputIndex);
        this.encoder.reset();
        CoderResult result = this.encoder.encode(in, out, true);
        this.handleResult(in, out, result);
        result = this.encoder.flush(out);
        this.handleResult(in, out, result);
        return out.position() - outputIndex;
    }

    public void reset() {
        this.encoder.reset();
    }

    public int encodeChar(int c, byte[] buffer, int off) throws CharEncodingException, EncodingBufferFullException {
        char[] inBuf = new char[2];
        if (c < 65535) {
            inBuf[0] = (char)c;
            return this.encodeChars(inBuf, 0, 1, buffer, off);
        }
        int lead = (c - 65536 >> 10) + 55296;
        int trail = (c - 65536 & 0x3FF) + 56320;
        inBuf[0] = (char)lead;
        inBuf[1] = (char)trail;
        return this.encodeChars(inBuf, 0, 2, buffer, off);
    }

    public String getEncoding() {
        return this.encoder.charset().name();
    }
}

