/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class EncodingStreamWriter
extends Writer {
    private CharEncoder encoder;
    private OutputStream stream;
    private int outputIndex = 0;
    private byte[] buffer = new byte[8192];

    public EncodingStreamWriter(OutputStream stream, String encoding) throws UnsupportedEncodingException {
        this(stream, CharEncoder.getEncoder(encoding));
    }

    public EncodingStreamWriter(OutputStream stream, CharEncoder encoder) {
        this.stream = stream;
        this.encoder = encoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBufferSize(int size) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            this.buffer = new byte[size];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBufferSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.buffer.length;
        }
    }

    public String getEncoding() {
        return this.encoder.getEncoding();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.flush();
            this.stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.outputIndex > 0) {
                this.stream.write(this.buffer, 0, this.outputIndex);
                this.outputIndex = 0;
                this.stream.flush();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int c) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                this.outputIndex += this.encoder.encodeChar(c & 0xFFFF, this.buffer, this.outputIndex);
            }
            catch (EncodingBufferFullException e) {
                if (this.tryFlush()) {
                    this.outputIndex += this.encoder.encodeChar(c & 0xFFFF, this.buffer, this.outputIndex);
                }
                throw e;
            }
        }
    }

    public void write(char[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    public void write(char[] buf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            while (true) {
                try {
                    if (this.buffer.length - this.outputIndex < 16) {
                        this.flush();
                    }
                    this.outputIndex += this.encoder.encodeChars(buf, off, len, this.buffer, this.outputIndex);
                    return;
                }
                catch (CharEncodingException cee) {
                    this.outputIndex = cee.getOutputOffset();
                    throw cee;
                }
                catch (EncodingBufferFullException e) {
                    this.outputIndex = e.getOutputIndex();
                    if (this.tryFlush()) {
                        len -= e.getInputIndex() - off;
                        off = e.getInputIndex();
                        continue;
                    }
                    throw e;
                }
                break;
            }
        }
    }

    public void write(String str) throws IOException {
        this.write(str, 0, str.length());
    }

    public void write(String str, int off, int len) throws IOException {
        char[] buf = new char[len];
        str.getChars(off, off + len, buf, 0);
        this.write(buf, 0, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean tryFlush() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.outputIndex > 0) {
                this.flush();
                return true;
            }
            return false;
        }
    }
}

