/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;

public class ISO88591Encoder
extends CharEncoder {
    public static final String NAME = "ISO-8859-1";

    public int encodeChars(char[] chars, int off, int len, byte[] buffer, int outputIndex) throws CharEncodingException, EncodingBufferFullException {
        int outOff = outputIndex;
        int max = off + len;
        for (int i = off; i < max; ++i) {
            char c = chars[i];
            if (c > '\u00ff') {
                if (c >= '\ud800' && c < '\udc00' && i + 1 < max) {
                    char trail = chars[++i];
                    int c32 = (c - 55296 << 10) + (trail - 56320) + 65536;
                    throw new CharEncodingException(c32, i, outOff);
                }
                throw new CharEncodingException(c & 0xFFFF, i, outOff);
            }
            if (outOff >= buffer.length) {
                throw new EncodingBufferFullException(outOff, i);
            }
            buffer[outOff++] = (byte)c;
        }
        return outOff - outputIndex;
    }

    public int encodeChar(int c, byte[] buffer, int off) throws CharEncodingException, EncodingBufferFullException {
        if (c > 255) {
            throw new CharEncodingException(c, 0, off);
        }
        if (off >= buffer.length) {
            throw new EncodingBufferFullException(off, 0);
        }
        buffer[off] = (byte)c;
        return 1;
    }

    public String getEncoding() {
        return NAME;
    }
}

