/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;

public abstract class ISO8859Encoder
extends CharEncoder {
    public static final int MAP_SIZE = 96;
    private final char[] charMap = new char[96];
    private final byte[] byteMap = new byte[96];

    protected ISO8859Encoder(char[] table) {
        if (table.length != 96) {
            throw new IllegalArgumentException("ISO8859Encoder: Wrong table size");
        }
        this.initMap(table);
    }

    public int encodeChars(char[] chars, int off, int len, byte[] buffer, int outputIndex) throws CharEncodingException, EncodingBufferFullException {
        int outOff = outputIndex;
        int max = off + len;
        for (int i = off; i < max; ++i) {
            int c = chars[i] & 0xFFFF;
            if (c > 126) {
                int index = Arrays.binarySearch(this.charMap, (char)c);
                if (index < 0) {
                    if (c >= 55296 && c < 56320 && i + 1 < max) {
                        char trail = chars[++i];
                        c = (c - 55296 << 10) + (trail - 56320) + 65536;
                    }
                    throw new CharEncodingException(c, i, outOff);
                }
                c = this.byteMap[index] & 0xFF;
            }
            if (outOff >= buffer.length) {
                throw new EncodingBufferFullException(outOff, i);
            }
            buffer[outOff++] = (byte)c;
        }
        return outOff - outputIndex;
    }

    public int encodeChar(int c, byte[] buffer, int off) throws CharEncodingException, EncodingBufferFullException {
        if (c > 126) {
            int index;
            if (c > 65535 || (index = Arrays.binarySearch(this.charMap, (char)c)) < 0) {
                throw new CharEncodingException(c, 0, off);
            }
            c = this.byteMap[index] & 0xFF;
        }
        if (off >= buffer.length) {
            throw new EncodingBufferFullException(off, 0);
        }
        buffer[off] = (byte)c;
        return 1;
    }

    private void initMap(char[] table) {
        int i;
        ArrayList<CharEntry> list = new ArrayList<CharEntry>(96);
        for (i = 0; i < 96; ++i) {
            list.add(new CharEntry(table[i], (byte)(i + 160)));
        }
        Collections.sort(list, new CharEntryComparator());
        for (i = 0; i < 96; ++i) {
            CharEntry ce = (CharEntry)list.get(i);
            this.charMap[i] = ce.c;
            this.byteMap[i] = ce.b;
        }
    }

    private static class CharEntryComparator
    implements Comparator {
        private CharEntryComparator() {
        }

        public int compare(Object lhs, Object rhs) {
            return ((CharEntry)lhs).c - ((CharEntry)rhs).c;
        }
    }

    private static class CharEntry {
        public final char c;
        public final byte b;

        public CharEntry(char c, byte b) {
            this.c = c;
            this.b = b;
        }
    }
}

