/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;

public class UTF16Encoder
extends CharEncoder {
    public static final String NAME = "UTF-16";
    private boolean first = true;

    public void reset() {
        this.first = false;
    }

    public int encodeChar(int c, byte[] buffer, int off) throws CharEncodingException, EncodingBufferFullException {
        int ret = 0;
        if (this.first) {
            if (off + 2 <= buffer.length) {
                buffer[off] = -1;
                buffer[off + 1] = -2;
                this.first = false;
                ret += 2;
            }
            off += 2;
        }
        if (c < 65535) {
            if (off + 2 <= buffer.length) {
                buffer[off] = (byte)(c & 0xFF);
                buffer[off + 1] = (byte)(c >> 8 & 0xFF);
                return ret + 2;
            }
        } else if (off + 4 <= buffer.length) {
            int lead = (c - 65536 >> 10) + 55296;
            int trail = (c - 65536 & 0x3FF) + 56320;
            buffer[off] = (byte)(lead & 0xFF);
            buffer[off + 1] = (byte)(lead >> 8 & 0xFF);
            buffer[off + 2] = (byte)(trail & 0xFF);
            buffer[off + 3] = (byte)(trail >> 8 & 0xFF);
            return ret + 4;
        }
        throw new EncodingBufferFullException(off, 0);
    }

    public String getEncoding() {
        return NAME;
    }
}

