/*
 * Decompiled with CFR 0.152.
 */
package com.novell.io;

import com.novell.io.CharEncoder;
import com.novell.io.CharEncodingException;
import com.novell.io.EncodingBufferFullException;

public class UTF8Encoder
extends CharEncoder {
    public static final String NAME = "UTF-8";

    public int encodeChar(int c, byte[] buffer, int off) throws CharEncodingException, EncodingBufferFullException {
        if (c < 0) {
            throw new CharEncodingException(c, 0, off);
        }
        if (c <= 127) {
            if (off < buffer.length) {
                buffer[off] = (byte)c;
                return 1;
            }
        } else if (c <= 2047) {
            if (off + 2 <= buffer.length) {
                buffer[off] = (byte)(0xC0 | 0x1F & c >> 6);
                buffer[off + 1] = (byte)(0x80 | 0x3F & c);
                return 2;
            }
        } else if (c <= 65535) {
            if (off + 3 <= buffer.length) {
                buffer[off] = (byte)(0xE0 | 0xF & c >> 12);
                buffer[off + 1] = (byte)(0x80 | 0x3F & c >> 6);
                buffer[off + 2] = (byte)(0x80 | 0x3F & c);
                return 3;
            }
        } else if (c < 0x1FFFFF) {
            if (off + 4 <= buffer.length) {
                buffer[off] = (byte)(0xF0 | 7 & c >> 18);
                buffer[off + 1] = (byte)(0x80 | 0x3F & c >> 12);
                buffer[off + 2] = (byte)(0x80 | 0x3F & c >> 6);
                buffer[off + 3] = (byte)(0x80 | 0x3F & c);
                return 4;
            }
        } else if (c <= 0x3FFFFFF) {
            if (off + 5 <= buffer.length) {
                buffer[off] = (byte)(0xF8 | 3 & c >> 24);
                buffer[off + 1] = (byte)(0x80 | 0x3F & c >> 18);
                buffer[off + 2] = (byte)(0x80 | 0x3F & c >> 12);
                buffer[off + 3] = (byte)(0x80 | 0x3F & c >> 6);
                buffer[off + 4] = (byte)(0x80 | 0x3F & c);
                return 5;
            }
        } else if (off + 6 <= buffer.length) {
            buffer[off] = (byte)(0xFC | 1 & c >> 30);
            buffer[off + 1] = (byte)(0x80 | 0x3F & c >> 24);
            buffer[off + 2] = (byte)(0x80 | 0x3F & c >> 18);
            buffer[off + 3] = (byte)(0x80 | 0x3F & c >> 12);
            buffer[off + 4] = (byte)(0x80 | 0x3F & c >> 6);
            buffer[off + 5] = (byte)(0x80 | 0x3F & c);
            return 6;
        }
        throw new EncodingBufferFullException(off, 0);
    }

    public String getEncoding() {
        return NAME;
    }
}

