/*
 * Decompiled with CFR 0.152.
 */
package com.novell.util;

import java.util.HashMap;
import java.util.Map;

public class StringCache {
    private static final int CACHE_INITIAL_SIZE = 64;
    private final Object lock = new Object();
    private Map map;
    private int maxEntry = 1;
    private String[] stringCache;

    public StringCache() {
        this(64);
    }

    public StringCache(int cacheSize) {
        this(new HashMap(), cacheSize);
    }

    public StringCache(Map mapImpl, int cacheSize) {
        this.map = mapImpl;
        this.stringCache = new String[cacheSize];
        this.getNumber("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumber(String str) {
        if (str.length() == 0) {
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            Integer value = (Integer)this.map.get(str);
            if (value != null) {
                return value;
            }
            this.map.put(str, new Integer(this.maxEntry));
            if (this.maxEntry == this.stringCache.length) {
                String[] temp = new String[this.stringCache.length * 2];
                System.arraycopy(this.stringCache, 0, temp, 0, this.stringCache.length);
                this.stringCache = temp;
            }
            this.stringCache[this.maxEntry] = str;
            return this.maxEntry++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(int number) {
        if (number == 0) {
            return "";
        }
        Object object = this.lock;
        synchronized (object) {
            if (0 <= number && number < this.maxEntry) {
                return this.stringCache[number];
            }
            return null;
        }
    }
}

