/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.dom.DocumentImpl;
import com.novell.xml.dom.ElementImpl;
import com.novell.xml.dom.NodeImpl;
import com.novell.xml.util.ExpandedQName;
import com.novell.xml.util.NamespaceName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttrImpl
extends NodeImpl
implements Attr {
    private String cachedValue = null;
    private ElementImpl owningElement = null;
    private boolean specified = true;
    private boolean idType = false;
    private boolean xpathBehavior = true;

    public short getNodeType() {
        return 2;
    }

    public String getNodeValue() throws DOMException {
        return this.getValue();
    }

    public void setNodeValue(String nodeValue) throws DOMException {
        this.setValue(nodeValue);
    }

    public Node getParentNode() {
        if (this.getXPathBehavior()) {
            return this.owningElement;
        }
        return null;
    }

    public NodeImpl getParentNodeEx() {
        if (this.getXPathBehavior()) {
            return this.owningElement;
        }
        return null;
    }

    public String getName() {
        return this.getNodeName();
    }

    public boolean getSpecified() {
        return this.specified;
    }

    public String getValue() {
        if (this.cachedValue == null) {
            if (this.getFirstChild() != this.getLastChild()) {
                StringBuffer value = new StringBuffer();
                for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                    value.append(node.getNodeValue());
                }
                this.cachedValue = value.toString();
            } else {
                this.cachedValue = this.getFirstChild() != null ? this.getFirstChild().getNodeValue() : "";
            }
        }
        return this.cachedValue;
    }

    public void setValue(String value) {
        this.gateModify();
        this.firstChild = null;
        this.lastChild = null;
        if (value != null) {
            this.appendChild(this.getOwnerDocument().createTextNode(value));
        }
        this.cachedValue = null;
    }

    public Element getOwnerElement() {
        return this.owningElement;
    }

    public boolean isId() {
        return this.idType;
    }

    public void setIdType(boolean idType) {
        this.idType = idType;
        if (this.owningElement != null && this.owningElement.document != null) {
            if (idType) {
                this.owningElement.document.addId(this.owningElement, this.getNodeValue());
            } else {
                this.owningElement.document.removeId(this.getNodeValue());
            }
        }
    }

    public String getBaseURI() {
        if (this.baseURI == null) {
            NodeImpl ancestor = this.owningElement;
            while (ancestor != null && ancestor.baseURI == null) {
                ancestor = ancestor.parentNode;
            }
            return ancestor != null ? ancestor.baseURI : null;
        }
        return this.baseURI;
    }

    public void setXPathBehavior(boolean xpathBehavior) {
        this.xpathBehavior = xpathBehavior;
    }

    public boolean getXPathBehavior() {
        return this.xpathBehavior;
    }

    protected void incChangeCount() {
        this.cachedValue = null;
        super.incChangeCount();
    }

    protected AttrImpl(DocumentImpl owner, String name) {
        super(owner, name);
    }

    protected AttrImpl(DocumentImpl owner, NamespaceName namespaceName, String qualifiedName) {
        super(owner, namespaceName, qualifiedName);
    }

    protected AttrImpl(DocumentImpl owner, ExpandedQName qName) {
        super(owner, qName);
    }

    protected void setOwningElement(ElementImpl owningElement) {
        this.owningElement = owningElement;
    }

    protected boolean isInUse() {
        return this.owningElement != null;
    }

    protected void setSpecified(boolean specified) {
        this.specified = specified;
    }
}

