/*
 * Decompiled with CFR 0.152.
 */
package com.novell.xml.dom;

import com.novell.xml.xpath.Expression;
import com.novell.xml.xpath.ExpressionContext;
import com.novell.xml.xpath.ExpressionValue;
import com.novell.xml.xpath.NamespaceContext;
import com.novell.xml.xpath.Parser;
import com.novell.xml.xpath.SingleNodeList;
import com.novell.xml.xpath.VariableBindings;
import com.novell.xml.xpath.XPathEvaluationException;
import com.novell.xml.xpath.XPathParserException;
import com.novell.xml.xpath.XPathResetCache;
import com.novell.xml.xpath.XPathResetRegistrar;
import com.novell.xsl.extensions.ExtensibleFunctionLibrary;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class DOMEvaluator
implements XPathResetRegistrar {
    private Expression expression;
    private ExpressionContext context;
    private SingleNodeList nodeList = new SingleNodeList();
    private List resetList = new ArrayList();

    public DOMEvaluator(String expression, Node nsNode, ClassLoader loader, VariableBindings varBindings, Map properties) throws IllegalArgumentException {
        this(expression, DOMEvaluator.createNamespaceContext(nsNode), loader, varBindings, properties);
    }

    public DOMEvaluator(String expression, NamespaceContext nsContext, ClassLoader loader, VariableBindings varBindings, Map properties) throws IllegalArgumentException {
        try {
            this.context = DOMEvaluator.createContext(properties);
            this.context.setContextNodeList(this.nodeList);
            Parser xpathParser = new Parser(varBindings, new ExtensibleFunctionLibrary(loader), nsContext == null ? this.context : nsContext);
            this.expression = xpathParser.parse(expression);
            this.expression.registerForReset(this);
        }
        catch (XPathParserException e) {
            throw new IllegalArgumentException("DOMEvaluator parser error: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExpressionValue evaluate(Node node) throws XPathEvaluationException {
        this.nodeList.setNode(node);
        try {
            ExpressionValue expressionValue = this.expression.evaluate(node, this.context);
            return expressionValue;
        }
        finally {
            this.nodeList.setNode(null);
            this.reset();
        }
    }

    private static ExpressionContext createContext(Map properties) {
        return new ExpressionContext(properties);
    }

    private static NamespaceContext createNamespaceContext(Node node) {
        ExpressionContext nsContext = new ExpressionContext();
        nsContext.setNamespaceContext(node);
        return nsContext;
    }

    public void registerResetCache(XPathResetCache reset) {
        this.resetList.add(reset);
    }

    private void reset() {
        Iterator it = this.resetList.iterator();
        while (it.hasNext()) {
            ((XPathResetCache)it.next()).resetCache();
        }
    }
}

